/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util.serializer;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.ballerinalang.model.util.serializer.SerializationBValueProvider;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.exceptions.BallerinaException;

class ObjectHelper {
    private static final String BVALUE_PACKAGE_PATH = ObjectHelper.getBValuePackagePath();
    public static final String DEPTH_SEP = "#";

    private ObjectHelper() {
    }

    static HashMap<String, Field> getAllFields(Class<?> targetClass, int depth) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Field declaredField : targetClass.getDeclaredFields()) {
            if (ObjectHelper.skip(declaredField)) continue;
            String name = depth == 0 ? declaredField.getName() : declaredField.getName() + DEPTH_SEP + depth;
            fieldMap.put(name, declaredField);
        }
        if (targetClass != Object.class) {
            fieldMap.putAll(ObjectHelper.getAllFields(targetClass.getSuperclass(), depth + 1));
        }
        return fieldMap;
    }

    private static boolean skip(Field declaredField) {
        int modifiers = declaredField.getModifiers();
        if (Modifier.isTransient(modifiers)) {
            return true;
        }
        return ObjectHelper.compileTimeConst(modifiers, declaredField.getType());
    }

    private static boolean compileTimeConst(int modifiers, Class<?> type) {
        return Modifier.isFinal(modifiers) && Modifier.isStatic(modifiers) && (type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE || type == Byte.TYPE || type == Character.TYPE || type == Float.TYPE || type == Double.TYPE || type == String.class);
    }

    static void setField(Object target, Field field, Object obj) {
        ObjectHelper.primeFinalFieldForAssignment(field);
        try {
            field.set(target, obj);
        }
        catch (IllegalAccessException e) {
            String targetClassName = target.getClass().getName();
            String fieldName = field.getName();
            throw new BallerinaException(String.format("Can not set field '%s' of '%s' via reflective deserialization, please provide a %s for %s", fieldName, targetClassName, SerializationBValueProvider.class.getSimpleName(), targetClassName), e);
        }
        catch (IllegalArgumentException e) {
            throw new BallerinaException(e);
        }
    }

    private static void primeFinalFieldForAssignment(Field field) {
        try {
            field.setAccessible(true);
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new BallerinaException(e);
        }
    }

    static Object invokeReadResolveOn(Object object, Class<?> clz) {
        try {
            Method readResolved = clz.getDeclaredMethod("readResolve", new Class[0]);
            if (readResolved != null) {
                readResolved.setAccessible(true);
                return readResolved.invoke(object, new Object[0]);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    static String getTrimmedClassName(Object obj) {
        Class<?> clazz = obj.getClass();
        return ObjectHelper.getTrimmedClassName(clazz);
    }

    static String getTrimmedClassName(Class<?> clazz) {
        String className = clazz.getName();
        if (BValue.class.isAssignableFrom(clazz) && className.startsWith(BVALUE_PACKAGE_PATH)) {
            className = className.substring(BVALUE_PACKAGE_PATH.length() + 1);
        }
        return className;
    }

    private static String getBValuePackagePath() {
        return BValue.class.getPackage().getName();
    }

    static boolean isInstantiable(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return !Modifier.isInterface(modifiers) || !Modifier.isAbstract(modifiers);
    }

    static Class<?> findPrimitiveClass(String typeName) {
        switch (typeName) {
            case "byte": {
                return Byte.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
        }
        return null;
    }
}

