/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util.serializer.providers.bvalue;

import java.util.LinkedHashSet;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.util.serializer.BPacket;
import org.ballerinalang.model.util.serializer.BValueDeserializer;
import org.ballerinalang.model.util.serializer.BValueSerializer;
import org.ballerinalang.model.util.serializer.SerializationBValueProvider;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValueArray;

public class LinkedHashSetBValueProvider
implements SerializationBValueProvider<LinkedHashSet> {
    @Override
    public String typeName() {
        return this.getType().getName();
    }

    @Override
    public Class<?> getType() {
        return LinkedHashSet.class;
    }

    @Override
    public BPacket toBValue(LinkedHashSet set, BValueSerializer serializer) {
        BValueArray array = new BValueArray(new BArrayType(BTypes.typeAny));
        for (Object item : set) {
            array.append((BRefType)serializer.toBValue(item, null));
        }
        return BPacket.from(this.typeName(), array).put("len#", new BInteger(set.size()));
    }

    @Override
    public LinkedHashSet toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
        BInteger length = (BInteger)packet.get("len#");
        BValueArray array = (BValueArray)packet.getValue();
        LinkedHashSet<Object> set = new LinkedHashSet<Object>((int)length.intValue());
        int i = 0;
        while ((long)i < array.size()) {
            set.add(bValueDeserializer.deserialize(array.getRefValue(i), null));
            ++i;
        }
        return set;
    }
}

