/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.util.List;
import java.util.Map;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.bre.bvm.BVMScheduler;
import org.ballerinalang.bre.bvm.StackFrame;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.bre.bvm.StrandCallback;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BFuture;
import org.ballerinalang.model.values.BValue;

public class BCallableFuture
implements BFuture {
    private String callableName;
    private Strand strand;

    public BCallableFuture(String callableName, Strand strand) {
        this.callableName = callableName;
        this.strand = strand;
    }

    @Override
    public String stringValue() {
        return "callable future: " + this.callableName;
    }

    @Override
    public BType getType() {
        return BTypes.typeFuture;
    }

    @Override
    public void stamp(BType type, List<BVM.TypeValuePair> unresolvedValues) {
    }

    @Override
    public BValue copy(Map<BValue, BValue> refs) {
        return new BCallableFuture(this.callableName, this.strand);
    }

    @Override
    public Strand value() {
        return this.strand;
    }

    @Override
    public boolean cancel() {
        if (this.isDone()) {
            return false;
        }
        StackFrame currentFrame = this.strand.currentFrame;
        if (currentFrame != null && currentFrame.callableUnitInfo.isNative()) {
            return false;
        }
        BVMScheduler.stateChange(this.strand, Strand.State.RUNNABLE, Strand.State.TERMINATED);
        this.strand.aborted = true;
        return true;
    }

    @Override
    public boolean isDone() {
        return this.strand.respCallback.getStatus() != StrandCallback.CallbackStatus.NOT_RETURNED;
    }

    @Override
    public boolean isCancelled() {
        return this.strand.aborted;
    }
}

