/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Map;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueType;
import org.ballerinalang.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.util.exceptions.BallerinaException;

public final class BInteger
extends BValueType
implements BRefType<Long> {
    private long value;
    private BType type = BTypes.typeInt;

    public BInteger(long value) {
        this.value = value;
    }

    @Override
    public long intValue() {
        return this.value;
    }

    @Override
    public long byteValue() {
        if (!BVM.isByteLiteral(this.value)) {
            throw new BallerinaException(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, "'int' value '" + this.value + "' cannot be converted to 'byte'");
        }
        return this.value;
    }

    @Override
    public double floatValue() {
        return this.value;
    }

    @Override
    public BigDecimal decimalValue() {
        return new BigDecimal(this.value, MathContext.DECIMAL128).setScale(1, 6);
    }

    @Override
    public boolean booleanValue() {
        return this.value != 0L;
    }

    @Override
    public String stringValue() {
        return Long.toString(this.value);
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public void setType(BType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BInteger bInteger = (BInteger)o;
        return this.value == bInteger.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public Long value() {
        return this.value;
    }

    @Override
    public BValue copy(Map<BValue, BValue> refs) {
        return this;
    }
}

