/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.persistence.serializable;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.bre.old.CallableWorkerResponseContext;
import org.ballerinalang.bre.old.WorkerData;
import org.ballerinalang.bre.old.WorkerExecutionContext;
import org.ballerinalang.bre.old.WorkerState;
import org.ballerinalang.model.util.serializer.JsonSerializer;
import org.ballerinalang.persistence.Deserializer;
import org.ballerinalang.persistence.Serializer;
import org.ballerinalang.persistence.serializable.SerializableState;
import org.ballerinalang.persistence.serializable.SerializableWorkerData;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.ServiceInfo;
import org.ballerinalang.util.codegen.WorkerInfo;

public class SerializableContext {
    public String contextKey;
    public String parent;
    public String respContextKey;
    public WorkerState state = WorkerState.CREATED;
    public HashMap<String, Object> localProps = new HashMap();
    public int ip;
    public SerializableWorkerData workerLocal;
    public SerializableWorkerData workerResult;
    public int[] retRegIndexes;
    public boolean runInCaller;
    public boolean interruptible;
    public String enclosingServiceName;
    public String callableUnitName;
    public String callableUnitPkgPath;
    public String workerName;

    public static SerializableContext deserialize(String jsonString) {
        JsonSerializer serializer = Serializer.getJsonSerializer();
        return serializer.deserialize(jsonString, SerializableContext.class);
    }

    public SerializableContext(String contextKey, WorkerExecutionContext ctx, SerializableState state, int ip) {
        this.contextKey = contextKey;
        this.ip = ip;
        this.populateProps(state.globalProps, ctx.globalProps, state);
        this.populateProps(this.localProps, ctx.localProps, state);
        this.retRegIndexes = ctx.retRegIndexes;
        this.runInCaller = ctx.runInCaller;
        this.interruptible = ctx.interruptible;
        if (ctx.callableUnitInfo != null) {
            this.callableUnitName = ctx.callableUnitInfo.getName();
            this.callableUnitPkgPath = ctx.callableUnitInfo.getPkgPath();
        }
        if (ctx.workerInfo != null) {
            this.workerName = ctx.workerInfo.getWorkerName();
        }
        if (ctx.respCtx != null && ctx.respCtx instanceof CallableWorkerResponseContext) {
            CallableWorkerResponseContext callableRespCtx = (CallableWorkerResponseContext)ctx.respCtx;
            this.respContextKey = state.addRespContext(callableRespCtx);
        }
        if (ctx.workerLocal != null) {
            this.workerLocal = new SerializableWorkerData(ctx.workerLocal, state);
        }
        if (ctx.workerResult != null) {
            this.workerResult = new SerializableWorkerData(ctx.workerResult, state);
        }
        if (ctx.parent != null) {
            this.parent = state.addContext(ctx.parent, ctx.parent.ip);
        }
    }

    public WorkerExecutionContext getWorkerExecutionContext(ProgramFile programFile, SerializableState state, Deserializer deserializer) {
        WorkerExecutionContext workerExecutionContext = deserializer.getContexts().get(this.contextKey);
        if (workerExecutionContext != null) {
            return workerExecutionContext;
        }
        FunctionInfo callableUnitInfo = null;
        WorkerInfo workerInfo = null;
        WorkerData workerLocalData = null;
        WorkerData workerResultData = null;
        Map<String, Object> tempGlobalProps = this.prepareProps(state.globalProps, state, programFile, deserializer);
        if (this.workerLocal != null) {
            workerLocalData = this.workerLocal.getWorkerData(programFile, state, deserializer);
        }
        if (this.workerResult != null) {
            workerResultData = this.workerResult.getWorkerData(programFile, state, deserializer);
        }
        if (this.callableUnitPkgPath != null) {
            PackageInfo packageInfo = programFile.getPackageInfo(this.callableUnitPkgPath);
            if (this.enclosingServiceName != null) {
                ServiceInfo serviceInfo = packageInfo.getServiceInfo(this.enclosingServiceName);
                tempGlobalProps.put("SERVICE_INFO", serviceInfo);
                callableUnitInfo = serviceInfo.getResourceInfo(this.callableUnitName);
                if (callableUnitInfo != null) {
                    workerInfo = "default".equals(this.workerName) ? callableUnitInfo.getDefaultWorkerInfo() : callableUnitInfo.getWorkerInfo(this.workerName);
                }
            } else {
                callableUnitInfo = packageInfo.getFunctionInfo(this.callableUnitName);
                if (callableUnitInfo != null) {
                    workerInfo = "default".equals(this.workerName) ? callableUnitInfo.getDefaultWorkerInfo() : callableUnitInfo.getWorkerInfo(this.workerName);
                }
            }
        }
        if (this.parent == null) {
            workerExecutionContext = new WorkerExecutionContext(programFile);
            workerExecutionContext.workerLocal = workerLocalData;
            workerExecutionContext.workerResult = workerResultData;
        } else {
            WorkerExecutionContext parentCtx = state.getContext(this.parent, programFile, deserializer);
            CallableWorkerResponseContext respCtx = state.getResponseContext(this.respContextKey, programFile, callableUnitInfo, deserializer);
            workerExecutionContext = new WorkerExecutionContext(parentCtx, respCtx, callableUnitInfo, workerInfo, workerLocalData, workerResultData, this.retRegIndexes, this.runInCaller);
        }
        workerExecutionContext.globalProps = tempGlobalProps;
        workerExecutionContext.localProps = this.prepareProps(this.localProps, state, programFile, deserializer);
        workerExecutionContext.ip = this.ip;
        workerExecutionContext.interruptible = this.interruptible;
        deserializer.getContexts().put(this.contextKey, workerExecutionContext);
        return workerExecutionContext;
    }

    private Map<String, Object> prepareProps(HashMap<String, Object> properties, SerializableState state, ProgramFile programFile, Deserializer deserializer) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (properties != null) {
            properties.forEach((s, o) -> {
                Object deserialize = state.deserialize(o, programFile, deserializer);
                props.put((String)s, deserialize);
            });
        }
        return props;
    }

    private void populateProps(HashMap<String, Object> properties, Map<String, Object> props, SerializableState state) {
        if (props != null) {
            props.forEach((s, o) -> properties.put((String)s, state.serialize(o)));
        }
    }
}

