/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.persistence.serializable.reftypes.impl;

import java.util.ArrayList;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.persistence.Deserializer;
import org.ballerinalang.persistence.serializable.SerializableState;
import org.ballerinalang.persistence.serializable.reftypes.SerializableRefType;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.StructureTypeInfo;
import org.ballerinalang.util.exceptions.BallerinaException;

public class SerializableBRefArray
implements SerializableRefType {
    private String structName;
    private String pkgPath;
    private ArrayList<Object> values = new ArrayList();

    public SerializableBRefArray(BValueArray bRefValueArray, SerializableState state) {
        BArrayType arrayType = (BArrayType)bRefValueArray.getType();
        if (arrayType != null) {
            this.structName = arrayType.getElementType().getName();
            this.pkgPath = arrayType.getElementType().getPackagePath();
        }
        int i = 0;
        while ((long)i < bRefValueArray.size()) {
            this.values.add(state.serialize(bRefValueArray.getRefValue(i)));
            ++i;
        }
    }

    @Override
    public BRefType getBRefType(ProgramFile programFile, SerializableState state, Deserializer deserializer) {
        PackageInfo packageInfo = programFile.getPackageInfo(this.pkgPath);
        BRefType[] bRefTypes = new BRefType[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            Object deserialize = state.deserialize(this.values.get(i), programFile, deserializer);
            bRefTypes[i] = deserialize instanceof BRefType ? (BRefType)deserialize : null;
        }
        BArrayType type = null;
        if (packageInfo != null) {
            StructureTypeInfo structInfo = packageInfo.getStructInfo(this.structName);
            if (structInfo == null) {
                throw new BallerinaException(this.structName + " not found in module " + this.pkgPath);
            }
            type = new BArrayType(structInfo.getType());
        }
        return new BValueArray(bRefTypes, type);
    }
}

