/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.persistence.store;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.ballerinalang.bre.old.WorkerExecutionContext;
import org.ballerinalang.persistence.Deserializer;
import org.ballerinalang.persistence.serializable.SerializableState;
import org.ballerinalang.persistence.states.State;
import org.ballerinalang.persistence.store.StorageProvider;
import org.ballerinalang.persistence.store.impl.FileStorageProvider;
import org.ballerinalang.util.codegen.ProgramFile;

public class PersistenceStore {
    private static StorageProvider storageProvider = new FileStorageProvider();

    public static void persistState(State state) {
        SerializableState sState = new SerializableState(state.getContext(), state.getIp());
        sState.setId(state.getId());
        String stateString = sState.serialize();
        storageProvider.persistState(state.getId(), stateString);
    }

    public static void removeStates(String stateId) {
        storageProvider.removeActiveState(stateId);
    }

    public static List<State> getStates(ProgramFile programFile) {
        List<String> serializedStates = storageProvider.getAllSerializedStates();
        if (serializedStates.isEmpty()) {
            return Collections.emptyList();
        }
        Deserializer deserializer = new Deserializer();
        LinkedList<State> states = new LinkedList<State>();
        for (String serializedState : serializedStates) {
            SerializableState sState = SerializableState.deserialize(serializedState);
            WorkerExecutionContext context = sState.getExecutionContext(programFile, deserializer);
            State state = new State(context, (String)context.globalProps.get("b7a.state.id"));
            --context.ip;
            state.setIp(context.ip);
            states.add(state);
        }
        deserializer.cleanUpDeserializer();
        return states;
    }

    public static void setStorageProvider(StorageProvider storageProvider) {
        PersistenceStore.storageProvider = storageProvider;
    }
}

