/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BField;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BDecimal;
import org.ballerinalang.model.values.BError;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.util.exceptions.BallerinaErrorReasons;
import org.ballerinalang.util.exceptions.BallerinaException;

public class TableUtils {
    private static final String DEFAULT_ERROR_DETAIL_MESSAGE = "Error occurred during table manipulation";

    public static String generateInsertDataStatment(String tableName, BMap<?, ?> constrainedType) {
        StringBuilder sbSql = new StringBuilder();
        StringBuilder sbValues = new StringBuilder();
        sbSql.append("INSERT INTO ").append(tableName).append(" (");
        Collection<BField> structFields = ((BStructureType)constrainedType.getType()).getFields().values();
        String sep = "";
        for (BField sf : structFields) {
            String name = sf.getFieldName();
            sbSql.append(sep).append(name).append(" ");
            sbValues.append(sep).append("?");
            sep = ",";
        }
        sbSql.append(") values (").append((CharSequence)sbValues).append(")");
        return sbSql.toString();
    }

    public static String generateDeleteDataStatment(String tableName, BMap<?, ?> constrainedType) {
        StringBuilder sbSql = new StringBuilder();
        sbSql.append("DELETE FROM ").append(tableName).append(" WHERE ");
        Collection<BField> structFields = ((BStructureType)constrainedType.getType()).getFields().values();
        String sep = "";
        for (BField sf : structFields) {
            String name = sf.getFieldName();
            sbSql.append(sep).append(name).append(" = ? ");
            sep = " AND ";
        }
        return sbSql.toString();
    }

    public static void prepareAndExecuteStatement(PreparedStatement stmt, BMap<String, BValue> constrainedType) {
        try {
            Collection<BField> structFields = ((BStructureType)constrainedType.getType()).getFields().values();
            int index = 1;
            for (BField sf : structFields) {
                int type = sf.getFieldType().getTag();
                String fieldName = sf.fieldName;
                switch (type) {
                    case 1: {
                        stmt.setLong(index, ((BInteger)constrainedType.get(fieldName)).intValue());
                        break;
                    }
                    case 5: {
                        stmt.setString(index, constrainedType.get(fieldName).stringValue());
                        break;
                    }
                    case 3: {
                        stmt.setDouble(index, ((BFloat)constrainedType.get(fieldName)).floatValue());
                        break;
                    }
                    case 4: {
                        stmt.setDouble(index, ((BDecimal)constrainedType.get(fieldName)).decimalValue().doubleValue());
                        break;
                    }
                    case 6: {
                        stmt.setBoolean(index, ((BBoolean)constrainedType.get(fieldName)).booleanValue());
                        break;
                    }
                    case 7: 
                    case 8: {
                        stmt.setString(index, constrainedType.get(fieldName).toString());
                        break;
                    }
                    case 19: {
                        boolean isBlobType;
                        boolean bl = isBlobType = ((BArrayType)sf.getFieldType()).getElementType().getTag() == 2;
                        if (isBlobType) {
                            BValue value = constrainedType.get(fieldName);
                            if (value != null) {
                                byte[] blobData = ((BValueArray)constrainedType.get(fieldName)).getBytes();
                                stmt.setBlob(index, new ByteArrayInputStream(blobData), blobData.length);
                                break;
                            }
                            stmt.setNull(index, 2004);
                            break;
                        }
                        Object[] arrayData = TableUtils.getArrayData(constrainedType.get(fieldName));
                        stmt.setObject(index, arrayData);
                    }
                }
                ++index;
            }
            stmt.execute();
        }
        catch (SQLException e) {
            throw new BallerinaException("execute update failed: " + e.getMessage(), e);
        }
    }

    static Object[] getArrayData(BValue value) {
        Object[] arrayData;
        if (value == null) {
            return new Object[]{null};
        }
        int typeTag = ((BArrayType)value.getType()).getElementType().getTag();
        switch (typeTag) {
            case 1: {
                int arrayLength = (int)((BValueArray)value).size();
                arrayData = new Long[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BValueArray)value).getInt(i);
                }
                break;
            }
            case 3: {
                int arrayLength = (int)((BValueArray)value).size();
                arrayData = new Double[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BValueArray)value).getFloat(i);
                }
                break;
            }
            case 5: {
                int arrayLength = (int)((BValueArray)value).size();
                arrayData = new String[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BValueArray)value).getString(i);
                }
                break;
            }
            case 6: {
                int arrayLength = (int)((BValueArray)value).size();
                arrayData = new Boolean[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BValueArray)value).getBoolean(i) > 0;
                }
                break;
            }
            case 4: {
                int arrayLength = (int)((BValueArray)value).size();
                arrayData = new BigDecimal[arrayLength];
                for (int i = 0; i < arrayLength; ++i) {
                    arrayData[i] = ((BValueArray)value).getRefValue(i).value();
                }
                break;
            }
            default: {
                throw new BallerinaException("unsupported data type for array parameter");
            }
        }
        return arrayData;
    }

    public static BError createTableOperationError(Context context, Throwable throwable) {
        String detail = throwable.getMessage() != null ? throwable.getMessage() : DEFAULT_ERROR_DETAIL_MESSAGE;
        BMap<String, BValue> tableErrorDetail = new BMap<String, BValue>();
        tableErrorDetail.put("message", new BString(detail));
        return BLangVMErrors.createError(context, true, BTypes.typeError, BallerinaErrorReasons.TABLE_OPERATION_ERROR, tableErrorDetail);
    }
}

