/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.cli;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.bre.bvm.BVM;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BMapType;
import org.ballerinalang.model.types.BStructureType;
import org.ballerinalang.model.types.BTupleType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.types.BUnionType;
import org.ballerinalang.model.util.JSONUtils;
import org.ballerinalang.model.util.JsonParser;
import org.ballerinalang.model.util.XMLUtils;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BByte;
import org.ballerinalang.model.values.BDecimal;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueArray;
import org.ballerinalang.util.codegen.DefaultValue;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.LocalVariableInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfo;
import org.ballerinalang.util.codegen.attributes.LocalVariableAttributeInfo;
import org.ballerinalang.util.codegen.attributes.ParamDefaultValueAttributeInfo;
import org.ballerinalang.util.codegen.attributes.ParameterAttributeInfo;
import org.ballerinalang.util.exceptions.BLangUsageException;
import org.ballerinalang.util.exceptions.BallerinaException;

public class ArgumentParser {
    private static final String DEFAULT_PARAM_PREFIX = "-";
    private static final String DEFAULT_PARAM_DELIMITER = "=";
    private static final String INVALID_ARG = "invalid argument: ";
    private static final String INVALID_ARG_AS_REST_ARG = "invalid argument as rest argument: ";
    private static final String UNSUPPORTED_TYPE_PREFIX = "unsupported type expected with entry function";
    private static final String JSON_PARSER_ERROR = "at line: ";
    private static final String COMMA = ",";
    private static final String NIL = "()";
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";
    private static final String HEX_PREFIX = "0X";

    public static BValue[] extractEntryFuncArgs(FunctionInfo entryFuncInfo, String[] args) {
        BType[] paramTypes = entryFuncInfo.getParamTypes();
        BValue[] bValueArgs = new BValue[paramTypes.length];
        ParameterAttributeInfo parameterAttributeInfo = (ParameterAttributeInfo)entryFuncInfo.getAttributeInfo(AttributeInfo.Kind.PARAMETERS_ATTRIBUTE);
        int requiredParamsCount = parameterAttributeInfo.requiredParamsCount;
        int defaultableParamsCount = parameterAttributeInfo.defaultableParamsCount;
        int restParamCount = parameterAttributeInfo.restParamCount;
        LocalVariableAttributeInfo localVariableAttributeInfo = (LocalVariableAttributeInfo)entryFuncInfo.getAttributeInfo(AttributeInfo.Kind.LOCAL_VARIABLES_ATTRIBUTE);
        ParamDefaultValueAttributeInfo paramDefaultValueAttributeInfo = (ParamDefaultValueAttributeInfo)entryFuncInfo.getAttributeInfo(AttributeInfo.Kind.PARAMETER_DEFAULTS_ATTRIBUTE);
        String[] requiredAndRestArgs = args;
        if (defaultableParamsCount > 0) {
            requiredAndRestArgs = ArgumentParser.populateNamedArgsAndRetrieveRequiredAndRestArgs(args, bValueArgs, localVariableAttributeInfo, paramDefaultValueAttributeInfo, requiredParamsCount, defaultableParamsCount);
        }
        if (requiredAndRestArgs.length < requiredParamsCount) {
            throw new BLangUsageException("insufficient arguments to call the 'main' function");
        }
        if (requiredAndRestArgs.length > requiredParamsCount && restParamCount == 0) {
            throw new BLangUsageException("too many arguments to call the 'main' function");
        }
        for (int index = 0; index < requiredParamsCount; ++index) {
            bValueArgs[index] = ArgumentParser.getBValue(paramTypes[index], requiredAndRestArgs[index]);
        }
        if (restParamCount == 1) {
            bValueArgs[paramTypes.length - 1] = ArgumentParser.getRestArgArray(paramTypes[paramTypes.length - 1], paramTypes.length - 1 - defaultableParamsCount, requiredAndRestArgs);
        }
        return bValueArgs;
    }

    private static String[] populateNamedArgsAndRetrieveRequiredAndRestArgs(String[] args, BValue[] bValueArgs, LocalVariableAttributeInfo localVariableAttributeInfo, ParamDefaultValueAttributeInfo paramDefaultValueAttributeInfo, int requiredParamsCount, int defaultableParamsCount) {
        HashMap<String, Integer> defaultableParamIndices = new HashMap<String, Integer>();
        List<LocalVariableInfo> localVariableInfoList = localVariableAttributeInfo.getLocalVariables();
        ArgumentParser.populateDefaultValues(bValueArgs, localVariableInfoList, paramDefaultValueAttributeInfo, requiredParamsCount, defaultableParamsCount, defaultableParamIndices);
        ArrayList<String> requiredAndRestArgs = new ArrayList<String>();
        for (String arg : args) {
            if (ArgumentParser.isDefaultParamCandidate(arg) && defaultableParamIndices.containsKey(ArgumentParser.getParamName(arg))) {
                int index = (Integer)defaultableParamIndices.get(ArgumentParser.getParamName(arg));
                bValueArgs[index] = ArgumentParser.getBValue(localVariableInfoList.get(index).getVariableType(), ArgumentParser.getValueString(arg));
                continue;
            }
            requiredAndRestArgs.add(arg);
        }
        return requiredAndRestArgs.toArray(new String[0]);
    }

    private static void populateDefaultValues(BValue[] bValueArgs, List<LocalVariableInfo> localVariableInfoList, ParamDefaultValueAttributeInfo paramDefaultValueAttributeInfo, int requiredParamsCount, int defaultableParamsCount, Map<String, Integer> defaultableParamIndices) {
        DefaultValue[] defaultValues = paramDefaultValueAttributeInfo.getDefaultValueInfo();
        int defaultValueIndex = 0;
        for (int defaultableParamIndex = requiredParamsCount; defaultableParamIndex < requiredParamsCount + defaultableParamsCount; ++defaultableParamIndex) {
            LocalVariableInfo localVariableInfo = localVariableInfoList.get(defaultableParamIndex);
            bValueArgs[defaultableParamIndex] = ArgumentParser.getDefaultValue(localVariableInfo.getVariableType(), defaultValues[defaultValueIndex++]);
            defaultableParamIndices.put(localVariableInfo.getVariableName(), defaultableParamIndex);
        }
    }

    private static boolean isDefaultParamCandidate(String arg) {
        return arg.startsWith(DEFAULT_PARAM_PREFIX) && arg.contains(DEFAULT_PARAM_DELIMITER);
    }

    private static String getParamName(String arg) {
        return arg.split(DEFAULT_PARAM_DELIMITER, 2)[0].substring(1).trim();
    }

    private static String getValueString(String arg) {
        return arg.split(DEFAULT_PARAM_DELIMITER, 2)[1];
    }

    private static BValue getDefaultValue(BType type, DefaultValue value) {
        switch (value.getTypeDesc()) {
            case "I": {
                return new BInteger(value.getIntValue());
            }
            case "S": {
                return new BString(value.getStringValue());
            }
            case "F": {
                return new BFloat(value.getFloatValue());
            }
            case "L": {
                return new BDecimal(value.getDecimalValue());
            }
            case "B": {
                return new BBoolean(value.getBooleanValue());
            }
            case "W": {
                return new BByte(value.getByteValue());
            }
            case "N": {
                return null;
            }
        }
        throw new BLangUsageException("unsupported type specified as defaultable param: " + type);
    }

    public static BValue getBValue(BType type, String value) {
        switch (type.getTag()) {
            case 5: 
            case 17: {
                return new BString(value);
            }
            case 1: {
                return new BInteger(ArgumentParser.getIntegerValue(value));
            }
            case 3: {
                return new BFloat(ArgumentParser.getFloatValue(value));
            }
            case 4: {
                return ArgumentParser.getDecimalValue(value);
            }
            case 6: {
                return new BBoolean(ArgumentParser.getBooleanValue(value));
            }
            case 2: {
                return new BByte(ArgumentParser.getByteValue(value));
            }
            case 8: {
                try {
                    return XMLUtils.parse(value);
                }
                catch (BallerinaException e) {
                    throw new BLangUsageException("invalid argument '" + value + "', expected XML value");
                }
            }
            case 7: {
                try {
                    return JsonParser.parse(value);
                }
                catch (BallerinaException e) {
                    throw new BLangUsageException("invalid argument '" + value + "', expected JSON value");
                }
            }
            case 12: {
                try {
                    return JSONUtils.convertJSONToStruct(JsonParser.parse(value), (BStructureType)type);
                }
                catch (BallerinaException e) {
                    throw new BLangUsageException("invalid argument '" + value + "', error constructing record of type: " + type + ": " + e.getLocalizedMessage().split(JSON_PARSER_ERROR)[0]);
                }
            }
            case 29: {
                if (!value.startsWith("[") || !value.endsWith("]")) {
                    throw new BLangUsageException("invalid argument '" + value + "', expected tuple notation [\"[]\"] with tuple arg");
                }
                return ArgumentParser.parseTupleArg((BTupleType)type, value.substring(1, value.length() - 1));
            }
            case 19: {
                try {
                    return JSONUtils.convertJSONToBArray(JsonParser.parse(value), (BArrayType)type);
                }
                catch (BallerinaException e) {
                    throw new BLangUsageException("invalid argument '" + value + "', expected array elements of type: " + ((BArrayType)type).getElementType());
                }
            }
            case 15: {
                try {
                    return JSONUtils.jsonToBMap(JsonParser.parse(value), (BMapType)type);
                }
                catch (BallerinaException e) {
                    throw new BLangUsageException("invalid argument '" + value + "', expected map argument of element type: " + ((BMapType)type).getConstrainedType());
                }
            }
            case 20: {
                return ArgumentParser.parseUnionArg((BUnionType)type, value);
            }
        }
        throw new BLangUsageException("unsupported type expected with entry function '" + type + "'");
    }

    private static long getIntegerValue(String argument) {
        try {
            if (argument.toUpperCase().startsWith(HEX_PREFIX)) {
                return Long.parseLong(argument.toUpperCase().replace(HEX_PREFIX, ""), 16);
            }
            return Long.parseLong(argument);
        }
        catch (NumberFormatException e) {
            throw new BLangUsageException("invalid argument '" + argument + "', expected integer value");
        }
    }

    private static double getFloatValue(String argument) {
        try {
            return Double.parseDouble(argument);
        }
        catch (NumberFormatException e) {
            throw new BLangUsageException("invalid argument '" + argument + "', expected float value");
        }
    }

    private static BDecimal getDecimalValue(String argument) {
        try {
            return new BDecimal(argument);
        }
        catch (NumberFormatException e) {
            throw new BLangUsageException("invalid argument '" + argument + "', expected decimal value");
        }
    }

    private static boolean getBooleanValue(String argument) {
        if (!TRUE.equalsIgnoreCase(argument) && !FALSE.equalsIgnoreCase(argument)) {
            throw new BLangUsageException("invalid argument '" + argument + "', expected boolean value 'true' or 'false'");
        }
        return Boolean.parseBoolean(argument);
    }

    private static long getByteValue(String argument) {
        long longValue;
        try {
            longValue = Long.parseLong(argument);
        }
        catch (NumberFormatException e) {
            throw new BLangUsageException("invalid argument '" + argument + "', expected byte value");
        }
        if (!BVM.isByteLiteral(longValue)) {
            throw new BLangUsageException("invalid argument '" + argument + "', expected byte value, found int");
        }
        return longValue;
    }

    private static BNewArray getRestArgArray(BType type, int index, String[] args) {
        BType elementType = ((BArrayType)type).getElementType();
        try {
            switch (elementType.getTag()) {
                case 5: 
                case 17: {
                    BValueArray stringArrayArgs = new BValueArray(BTypes.typeString);
                    for (int i = index; i < args.length; ++i) {
                        stringArrayArgs.add((long)(i - index), args[i]);
                    }
                    return stringArrayArgs;
                }
                case 1: {
                    BValueArray intArrayArgs = new BValueArray(BTypes.typeInt);
                    for (int i = index; i < args.length; ++i) {
                        intArrayArgs.add((long)(i - index), ArgumentParser.getIntegerValue(args[i]));
                    }
                    return intArrayArgs;
                }
                case 3: {
                    BValueArray floatArrayArgs = new BValueArray(BTypes.typeFloat);
                    for (int i = index; i < args.length; ++i) {
                        floatArrayArgs.add((long)(i - index), ArgumentParser.getFloatValue(args[i]));
                    }
                    return floatArrayArgs;
                }
                case 6: {
                    BValueArray booleanArrayArgs = new BValueArray(BTypes.typeBoolean);
                    for (int i = index; i < args.length; ++i) {
                        booleanArrayArgs.add((long)(i - index), ArgumentParser.getBooleanValue(args[i]) ? 1 : 0);
                    }
                    return booleanArrayArgs;
                }
                case 2: {
                    BValueArray byteArrayArgs = new BValueArray(BTypes.typeByte);
                    for (int i = index; i < args.length; ++i) {
                        byteArrayArgs.add((long)(i - index), (byte)ArgumentParser.getByteValue(args[i]));
                    }
                    return byteArrayArgs;
                }
            }
            BValueArray refValueArray = new BValueArray();
            for (int i = index; i < args.length; ++i) {
                refValueArray.add((long)(i - index), (BRefType)ArgumentParser.getBValue(elementType, args[i]));
            }
            return refValueArray;
        }
        catch (BLangUsageException e) {
            throw new BLangUsageException(e.getLocalizedMessage().replace(INVALID_ARG, INVALID_ARG_AS_REST_ARG));
        }
        catch (Exception e) {
            throw new BLangUsageException("error parsing rest arg: " + e.getLocalizedMessage());
        }
    }

    private static BValueArray parseTupleArg(BTupleType type, String tupleArg) {
        String stringSpecificationErrorSuffix = "', expected argument in the format \\\"str\\\" for tuple element of type 'string'";
        String[] tupleElements = tupleArg.split(COMMA);
        if (tupleElements.length != type.getTupleTypes().size()) {
            throw new BLangUsageException("invalid argument '[" + tupleArg + "]', element count mismatch for tuple type: '" + type + "'");
        }
        BValueArray tupleValues = new BValueArray(type);
        int index = 0;
        for (BType elementType : type.getTupleTypes()) {
            String tupleElement = tupleElements[index].trim();
            try {
                if (elementType.getTag() == 5) {
                    if (!tupleElement.startsWith("\"") || !tupleElement.endsWith("\"")) {
                        throw new BLangUsageException("invalid tuple element argument '" + tupleElement + stringSpecificationErrorSuffix);
                    }
                    tupleElement = tupleElement.substring(1, tupleElement.length() - 1);
                }
                tupleValues.add((long)index, (BRefType)ArgumentParser.getBValue(elementType, tupleElement));
                ++index;
            }
            catch (BLangUsageException | BallerinaException e) {
                String localizedMessage = e.getLocalizedMessage();
                if (localizedMessage.startsWith(UNSUPPORTED_TYPE_PREFIX)) {
                    throw new BLangUsageException("unsupported element type for tuple as entry function argument: " + elementType);
                }
                if (!localizedMessage.endsWith(stringSpecificationErrorSuffix)) {
                    throw new BLangUsageException("invalid tuple member argument '" + tupleElement + "', expected value of type '" + elementType + "'");
                }
                throw e;
            }
        }
        return tupleValues;
    }

    private static BValue parseUnionArg(BUnionType type, String unionArg) {
        List<BType> unionMemberTypes = type.getMemberTypes();
        if (unionMemberTypes.contains(BTypes.typeNull) && NIL.equals(unionArg)) {
            return null;
        }
        if (unionMemberTypes.contains(BTypes.typeString)) {
            return new BString(unionArg);
        }
        int memberTypeIndex = 0;
        while (memberTypeIndex < unionMemberTypes.size()) {
            try {
                BType memberType = unionMemberTypes.get(memberTypeIndex);
                if (memberType.getTag() == 10) {
                    ++memberTypeIndex;
                    continue;
                }
                return ArgumentParser.getBValue(memberType, unionArg);
            }
            catch (BLangUsageException e) {
                ++memberTypeIndex;
            }
        }
        throw new BLangUsageException("invalid argument '" + unionArg + "' specified for union type: " + (type.isNilable() ? type.toString().replace("|null", "|()") : type));
    }
}

