/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.codegen;

import java.util.ArrayList;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfo;
import org.ballerinalang.util.codegen.attributes.ErrorTableAttributeInfo;

public class ErrorTableEntry {
    private int ipFrom;
    private int ipTo;
    public int ipTarget;
    public int regIndex;

    ErrorTableEntry(int ipFrom, int ipTo, int ipTarget, int regIndex) {
        this.ipFrom = ipFrom;
        this.ipTo = ipTo;
        this.ipTarget = ipTarget;
        this.regIndex = regIndex;
    }

    private boolean matchRange(int currentIP) {
        return currentIP >= this.ipFrom && currentIP <= this.ipTo;
    }

    public String toString() {
        return "\t\t" + this.ipFrom + "\t\t" + this.ipTo + "\t" + this.ipTarget + "\t\t" + this.regIndex;
    }

    public static ErrorTableEntry getMatch(PackageInfo packageInfo, int currentIP) {
        ErrorTableAttributeInfo errorTable = (ErrorTableAttributeInfo)packageInfo.getAttributeInfo(AttributeInfo.Kind.ERROR_TABLE);
        ArrayList errorTableEntries = errorTable != null ? errorTable.getErrorTableEntriesList() : new ArrayList();
        return errorTableEntries.stream().filter(errorTableEntry -> errorTableEntry.matchRange(currentIP)).findFirst().orElse(null);
    }
}

