/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.codegen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfoPool;
import org.ballerinalang.util.codegen.cpentries.TypeRefCPEntry;

public class ServiceInfo
implements AttributeInfoPool {
    protected int pkgPathCPIndex;
    protected String packagePath;
    protected int nameCPIndex;
    protected String name;
    public int flags;
    public TypeRefCPEntry serviceType;
    private Map<String, FunctionInfo> resourceInfoMap;
    private List<String> resourceNameList = new ArrayList<String>();
    private PackageInfo packageInfo;
    private Map<AttributeInfo.Kind, AttributeInfo> attributeInfoMap = new HashMap<AttributeInfo.Kind, AttributeInfo>();
    public BMap serviceValue;

    public ServiceInfo(int pkgPathCPIndex, String packageName, int nameCPIndex, String serviceName, int flags, TypeRefCPEntry serviceType) {
        this.pkgPathCPIndex = pkgPathCPIndex;
        this.packagePath = packageName;
        this.nameCPIndex = nameCPIndex;
        this.name = serviceName;
        this.flags = flags;
        this.serviceType = serviceType;
    }

    public FunctionInfo[] getResourceInfoEntries() {
        if (this.resourceInfoMap == null) {
            this.resourceInfoMap = new HashMap<String, FunctionInfo>();
            for (String name : this.resourceNameList) {
                this.resourceInfoMap.put(name, this.packageInfo.getFunctionInfo(name));
            }
        }
        return this.resourceInfoMap.values().toArray(new FunctionInfo[0]);
    }

    public void addResourceInfo(String resourceName) {
        this.resourceNameList.add(resourceName);
    }

    public FunctionInfo getResourceInfo(String resourceName) {
        return this.resourceInfoMap.get(resourceName);
    }

    public String getName() {
        return this.name;
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    protected void setPackageInfo(PackageInfo packageInfo) {
        this.packageInfo = packageInfo;
    }

    public BType getType() {
        return this.serviceType.getType();
    }

    public int hashCode() {
        return Objects.hash(this.pkgPathCPIndex, this.nameCPIndex);
    }

    public boolean equals(Object obj) {
        return obj instanceof ServiceInfo && this.pkgPathCPIndex == ((ServiceInfo)obj).pkgPathCPIndex && this.nameCPIndex == ((ServiceInfo)obj).nameCPIndex;
    }

    @Override
    public AttributeInfo getAttributeInfo(AttributeInfo.Kind attributeKind) {
        return this.attributeInfoMap.get((Object)attributeKind);
    }

    @Override
    public void addAttributeInfo(AttributeInfo.Kind attributeKind, AttributeInfo attributeInfo) {
        this.attributeInfoMap.put(attributeKind, attributeInfo);
    }

    @Override
    public AttributeInfo[] getAttributeInfoEntries() {
        return this.attributeInfoMap.values().toArray(new AttributeInfo[0]);
    }
}

