/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.debugger.dto;

import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueType;
import org.ballerinalang.model.values.BXML;

public class VariableDTO {
    private String scope;
    private String name;
    private String type;
    private String value;

    public VariableDTO(String name, String scope) {
        this.scope = scope;
        this.name = name;
    }

    public String getScope() {
        return this.scope;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public void setBValue(BValue bValue) {
        if (bValue == null) {
            this.type = "null";
            this.value = "null";
            return;
        }
        this.type = bValue.getType().toString();
        this.value = this.getStringValue(bValue);
    }

    public void setBValue(BValue bValue, BType bType) {
        this.type = bType.toString();
        this.value = this.getStringValue(bValue);
    }

    private String getStringValue(BValue bValue) {
        String bValueString;
        if (bValue == null) {
            bValueString = null;
        } else if (bValue instanceof BValueType || bValue instanceof BXML || bValue.getType().getTag() == 7) {
            bValueString = bValue.stringValue();
        } else if (bValue instanceof BNewArray) {
            BNewArray bArray = (BNewArray)bValue;
            bValueString = "Array[" + bArray.size() + "] ";
            bValueString = bValueString + bArray.stringValue();
        } else if (bValue.getType().getTag() == 15) {
            BMap bmap = (BMap)bValue;
            bValueString = "Map[" + bmap.size() + "] ";
            bValueString = bValueString + bmap.stringValue();
        } else if (bValue.getType().getTag() == 12) {
            bValueString = "Record " + bValue.getType().getName() + " ";
            bValueString = bValueString + bValue.stringValue();
        } else if (bValue.getType().getTag() == 33) {
            bValueString = "Object " + bValue.getType().getName() + " ";
            bValueString = bValueString + ((BMap)bValue).absoluteStringValue();
        } else {
            bValueString = "<Complex_Value>";
        }
        return bValueString;
    }

    public String toString() {
        return "(" + this.scope + ") " + this.name + " = " + this.value + " {" + this.type + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariableDTO var = (VariableDTO)o;
        return this.scope.equals(var.scope) && this.name.equals(var.name) && this.type.equals(var.type) && (this.value != null ? this.value.equals(var.value) : var.value == null);
    }

    public int hashCode() {
        int result = this.scope.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

