/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.exceptions;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.exceptions.RuntimeErrors;
import org.ballerinalang.util.exceptions.SemanticException;

public class BLangExceptionHelper {
    private static ResourceBundle messageBundle = ResourceBundle.getBundle("MessagesBundle", Locale.getDefault());

    public static void throwSemanticError(String errorMessage) {
        throw new SemanticException(errorMessage);
    }

    public static BallerinaException getRuntimeException(RuntimeErrors runtimeErrors, Object ... params) {
        String errorMsg = MessageFormat.format(messageBundle.getString(runtimeErrors.getErrorMsgKey()), params);
        return new BallerinaException(errorMsg);
    }

    public static BallerinaException getRuntimeException(String reason, RuntimeErrors runtimeErrors, Object ... params) {
        String errorDetail = MessageFormat.format(messageBundle.getString(runtimeErrors.getErrorMsgKey()), params);
        return new BallerinaException(reason, errorDetail);
    }

    public static String getErrorMessage(RuntimeErrors runtimeErrors, Object ... params) {
        return MessageFormat.format(messageBundle.getString(runtimeErrors.getErrorMsgKey()), params);
    }
}

