/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.tracer;

import io.opentracing.Tracer;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.ballerinalang.config.ConfigRegistry;
import org.ballerinalang.util.tracer.OpenTracer;
import org.ballerinalang.util.tracer.exception.InvalidConfigurationException;

public class TracersStore {
    private TracerGenerator tracer;
    private Map<String, Tracer> tracerStore;
    private static final PrintStream consoleError = System.err;
    private static TracersStore instance = new TracersStore();

    public static TracersStore getInstance() {
        return instance;
    }

    private TracersStore() {
    }

    public void loadTracers() {
        ConfigRegistry configRegistry = ConfigRegistry.getInstance();
        if (configRegistry.getAsBoolean("b7a.observability.tracing.enabled")) {
            this.tracerStore = new HashMap<String, Tracer>();
            ServiceLoader<OpenTracer> openTracers = ServiceLoader.load(OpenTracer.class);
            HashMap tracerMap = new HashMap();
            openTracers.forEach(t -> tracerMap.put(t.getName().toLowerCase(), t));
            String tracerName = configRegistry.getConfigOrDefault("b7a.observability.tracing.name", "jaeger");
            OpenTracer openTracer = (OpenTracer)tracerMap.get(tracerName.toLowerCase());
            if (openTracer != null) {
                try {
                    openTracer.init();
                    this.tracer = new TracerGenerator(openTracer.getName(), openTracer);
                }
                catch (InvalidConfigurationException e) {
                    consoleError.println("error: error in observability tracing configurations: " + e.getMessage());
                }
            } else {
                consoleError.println("error: observability enabled but no tracing extension found for name " + tracerName);
            }
        } else {
            this.tracerStore = new HashMap<String, Tracer>();
        }
    }

    public Tracer getTracer(String serviceName) {
        if (this.tracerStore.containsKey(serviceName)) {
            return this.tracerStore.get(serviceName);
        }
        Tracer openTracer = null;
        if (this.tracer != null) {
            try {
                openTracer = this.tracer.generate(serviceName);
            }
            catch (Throwable e) {
                consoleError.println("error: error getting tracer for " + this.tracer.name + ". " + e.getMessage());
            }
        }
        this.tracerStore.put(serviceName, openTracer);
        return openTracer;
    }

    public boolean isInitialized() {
        return this.tracerStore != null;
    }

    private static class TracerGenerator {
        String name;
        OpenTracer tracer;

        TracerGenerator(String name, OpenTracer tracer) {
            this.name = name;
            this.tracer = tracer;
        }

        Tracer generate(String serviceName) {
            return this.tracer.getTracer(this.name, serviceName);
        }
    }
}

