/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.util.transactions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.ballerinalang.bre.bvm.BVMExecutor;
import org.ballerinalang.bre.bvm.Strand;
import org.ballerinalang.model.values.BFunctionPointer;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.transactions.BallerinaTransactionContext;
import org.ballerinalang.util.transactions.TransactionLocalContext;
import org.ballerinalang.util.transactions.TransactionUtils;
import org.ballerinalang.util.transactions.XIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionResourceManager {
    private static TransactionResourceManager transactionResourceManager = null;
    private static final Logger log = LoggerFactory.getLogger(TransactionResourceManager.class);
    private Map<String, List<BallerinaTransactionContext>> resourceRegistry;
    private Map<String, Xid> xidRegistry;
    private Map<String, BFunctionPointer> committedFuncRegistry;
    private Map<String, BFunctionPointer> abortedFuncRegistry;
    private ConcurrentSkipListSet<String> failedResourceParticipantSet = new ConcurrentSkipListSet();
    private ConcurrentSkipListSet<String> failedLocalParticipantSet = new ConcurrentSkipListSet();
    private ConcurrentHashMap<String, ConcurrentSkipListSet<String>> localParticipants = new ConcurrentHashMap();

    private TransactionResourceManager() {
        this.resourceRegistry = new HashMap<String, List<BallerinaTransactionContext>>();
        this.xidRegistry = new HashMap<String, Xid>();
        this.committedFuncRegistry = new HashMap<String, BFunctionPointer>();
        this.abortedFuncRegistry = new HashMap<String, BFunctionPointer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TransactionResourceManager getInstance() {
        if (transactionResourceManager != null) return transactionResourceManager;
        Class<TransactionResourceManager> clazz = TransactionResourceManager.class;
        synchronized (TransactionResourceManager.class) {
            if (transactionResourceManager != null) return transactionResourceManager;
            transactionResourceManager = new TransactionResourceManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return transactionResourceManager;
        }
    }

    public void register(String transactionId, String transactionBlockId, BallerinaTransactionContext txContext) {
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        this.resourceRegistry.computeIfAbsent(combinedId, resourceList -> new ArrayList()).add(txContext);
    }

    public void registerCommittedFunction(String transactionBlockId, BFunctionPointer bFunctionPointer) {
        this.committedFuncRegistry.put(transactionBlockId, bFunctionPointer);
    }

    public void registerAbortedFunction(String transactionBlockId, BFunctionPointer bFunctionPointer) {
        this.abortedFuncRegistry.put(transactionBlockId, bFunctionPointer);
    }

    public void registerParticipation(String gTransactionId, String transactionBlockId, BFunctionPointer committed, BFunctionPointer aborted, Strand strand) {
        this.localParticipants.computeIfAbsent(gTransactionId, gid -> new ConcurrentSkipListSet()).add(transactionBlockId);
        TransactionLocalContext transactionLocalContext = strand.getLocalTransactionContext();
        this.registerCommittedFunction(transactionBlockId, committed);
        this.registerAbortedFunction(transactionBlockId, aborted);
        transactionLocalContext.beginTransactionBlock(transactionBlockId, 1);
        BValue[] bValues = TransactionUtils.notifyTransactionBegin(strand, transactionLocalContext.getGlobalTransactionId(), transactionLocalContext.getURL(), transactionBlockId, transactionLocalContext.getProtocol());
        log.info("participant registered: " + bValues[0]);
    }

    public boolean prepare(String transactionId, String transactionBlockId) {
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        List<BallerinaTransactionContext> txContextList = this.resourceRegistry.get(combinedId);
        if (txContextList != null) {
            for (BallerinaTransactionContext ctx : txContextList) {
                try {
                    XAResource xaResource = ctx.getXAResource();
                    if (xaResource == null) continue;
                    Xid xid = this.xidRegistry.get(combinedId);
                    xaResource.prepare(xid);
                }
                catch (Throwable e) {
                    log.error("error in prepare the transaction, " + combinedId + ":" + e.getMessage(), e);
                    return false;
                }
            }
        }
        boolean status = true;
        if (this.failedResourceParticipantSet.contains(transactionId) || this.failedLocalParticipantSet.contains(transactionId)) {
            status = false;
        }
        log.info(String.format("Transaction prepare (participants): %s", status ? "success" : "failed"));
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyCommit(String transactionId, String transactionBlockId) {
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        boolean commitSuccess = true;
        List<BallerinaTransactionContext> txContextList = this.resourceRegistry.get(combinedId);
        if (txContextList != null) {
            for (BallerinaTransactionContext ctx : txContextList) {
                try {
                    XAResource xaResource = ctx.getXAResource();
                    if (xaResource != null) {
                        Xid xid = this.xidRegistry.get(combinedId);
                        xaResource.commit(xid, false);
                        continue;
                    }
                    ctx.commit();
                }
                catch (Throwable e) {
                    log.error("error in commit the transaction, " + combinedId + ":" + e.getMessage(), e);
                    commitSuccess = false;
                }
                finally {
                    ctx.close();
                }
            }
        }
        this.invokeCommittedFunction(transactionId, transactionBlockId);
        this.removeContextsFromRegistry(combinedId, transactionId);
        this.failedResourceParticipantSet.remove(transactionId);
        this.failedLocalParticipantSet.remove(transactionId);
        this.localParticipants.remove(transactionId);
        return commitSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifyAbort(String transactionId, String transactionBlockId, boolean isRetryAttempt) {
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        boolean abortSuccess = true;
        List<BallerinaTransactionContext> txContextList = this.resourceRegistry.get(combinedId);
        if (txContextList != null) {
            for (BallerinaTransactionContext ctx : txContextList) {
                try {
                    XAResource xaResource = ctx.getXAResource();
                    Xid xid = this.xidRegistry.get(combinedId);
                    if (xaResource != null) {
                        ctx.getXAResource().rollback(xid);
                        continue;
                    }
                    ctx.rollback();
                }
                catch (Throwable e) {
                    log.error("error in abort the transaction, " + combinedId + ":" + e.getMessage(), e);
                    abortSuccess = false;
                }
                finally {
                    ctx.close();
                }
            }
        }
        this.removeContextsFromRegistry(combinedId, transactionId);
        this.failedResourceParticipantSet.remove(transactionId);
        this.failedLocalParticipantSet.remove(transactionId);
        this.localParticipants.remove(transactionId);
        return abortSuccess;
    }

    public void beginXATransaction(String transactionId, String transactionBlockId, XAResource xaResource) {
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        Xid xid = this.xidRegistry.get(combinedId);
        if (xid == null) {
            xid = XIDGenerator.createXID();
            this.xidRegistry.put(combinedId, xid);
        }
        try {
            xaResource.start(xid, 0);
        }
        catch (XAException e) {
            throw new BallerinaException("error in starting the XA transaction: id: " + combinedId + " error:" + e.getMessage());
        }
    }

    void endXATransaction(String transactionId, String transactionBlockId) {
        List<BallerinaTransactionContext> txContextList;
        String combinedId = this.generateCombinedTransactionId(transactionId, transactionBlockId);
        Xid xid = this.xidRegistry.get(combinedId);
        if (xid != null && (txContextList = this.resourceRegistry.get(combinedId)) != null) {
            for (BallerinaTransactionContext ctx : txContextList) {
                try {
                    XAResource xaResource = ctx.getXAResource();
                    if (xaResource == null) continue;
                    ctx.getXAResource().end(xid, 0x4000000);
                }
                catch (Throwable e) {
                    throw new BallerinaException("error in ending the XA transaction: id: " + combinedId + " error:" + e.getMessage());
                }
            }
        }
    }

    void rollbackTransaction(String transactionId, String transactionBlockId) {
        this.endXATransaction(transactionId, transactionBlockId);
        this.notifyAbort(transactionId, transactionBlockId, true);
    }

    private void removeContextsFromRegistry(String transactionCombinedId, String gTransactionId) {
        this.resourceRegistry.remove(transactionCombinedId);
        this.xidRegistry.remove(transactionCombinedId);
    }

    private String generateCombinedTransactionId(String transactionId, String transactionBlockId) {
        return transactionId + ":" + transactionBlockId;
    }

    private void invokeCommittedFunction(String transactionId, String transactionBlockId) {
        BFunctionPointer fp = this.committedFuncRegistry.get(transactionBlockId);
        BValue[] args = new BValue[]{new BString(transactionId + ":" + transactionBlockId)};
        if (fp != null) {
            BVMExecutor.executeFunction(fp.value().getPackageInfo().getProgramFile(), fp.value(), args);
        }
    }

    public void notifyResourceFailure(String gTransactionId) {
        this.failedResourceParticipantSet.add(gTransactionId);
        log.info("Trx infected callable unit excepted id : " + gTransactionId);
    }

    public void notifyLocalParticipantFailure(String gTransactionId, String blockId) {
        ConcurrentSkipListSet<String> participantBlockIds = this.localParticipants.get(gTransactionId);
        if (participantBlockIds != null && participantBlockIds.contains(blockId)) {
            this.failedLocalParticipantSet.add(gTransactionId);
        }
    }
}

