/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.types;

import org.ballerinalang.model.NodeLocation;

public class SimpleTypeName {
    protected NodeLocation location;
    protected String name;
    protected String pkgName;
    protected String pkgPath;
    protected boolean isArrayType;
    protected int dimensions = 1;

    public SimpleTypeName(String name, String pkgName, String pkgPath) {
        this.name = name;
        this.pkgName = pkgName;
        this.pkgPath = pkgPath;
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        return this.pkgName;
    }

    public String getPackagePath() {
        return this.pkgPath;
    }

    public void setPkgPath(String pkgPath) {
        this.pkgPath = pkgPath;
    }

    public boolean isArrayType() {
        return this.isArrayType;
    }

    public String getNameWithPkg() {
        return this.pkgName == null || this.pkgName.equals("") ? this.name : this.pkgName + ":" + this.name;
    }

    protected String getNameWithArray(String name) {
        if (this.isArrayType) {
            String arrayName = name;
            for (int i = 0; i < this.getDimensions(); ++i) {
                arrayName = arrayName + "[]";
            }
            return arrayName;
        }
        return name;
    }

    public String toString() {
        return this.getNameWithArray(this.getNameWithPkg());
    }

    public int getDimensions() {
        return this.dimensions;
    }
}

