/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;

public class BError
implements BRefType {
    BType type;
    private String message;
    private BRefType details;
    public List<BMap<String, BValue>> callStack;
    private BError cause;

    public BError(BType type, String message, BError cause, BRefType details) {
        this.type = type;
        this.message = message;
        this.cause = cause;
        this.details = details;
        this.callStack = new ArrayList<BMap<String, BValue>>();
    }

    @Override
    public String stringValue() {
        return this.message + " " + this.details.stringValue();
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public BValue copy(Map<BValue, BValue> refs) {
        return this;
    }

    @Deprecated
    public String getReason() {
        return this.message;
    }

    public String getMessage() {
        return this.message;
    }

    public BRefType getDetails() {
        return this.details;
    }

    public Object value() {
        return null;
    }

    @Override
    public boolean isFrozen() {
        return true;
    }

    public BError getCause() {
        return this.cause;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BError) {
            BError that = (BError)obj;
            boolean isCauseSame = false;
            if (this.cause != null) {
                isCauseSame = this.cause.equals(that.cause);
            } else if (that.cause == null) {
                isCauseSame = true;
            }
            return this.message.equals(that.message) && this.details.equals(that.details) && isCauseSame;
        }
        return false;
    }
}

