/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.IntStream;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BTupleType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.util.JsonGenerator;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BByte;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.wso2.ballerinalang.compiler.util.BArrayState;

public class BValueArray
extends BNewArray {
    BRefType<?>[] refValues;
    private long[] intValues;
    private int[] booleanValues;
    private byte[] byteValues;
    private double[] floatValues;
    private String[] stringValues;
    public BType elementType;

    public BValueArray(BRefType<?>[] values, BType type) {
        this.refValues = values;
        this.arrayType = type;
        this.size = values.length;
    }

    public BValueArray(long[] values) {
        this.intValues = values;
        this.size = values.length;
        this.setArrayElementType(BTypes.typeInt);
    }

    public BValueArray(int[] values) {
        this.booleanValues = values;
        this.size = values.length;
        this.setArrayElementType(BTypes.typeBoolean);
    }

    public BValueArray(byte[] values) {
        this.byteValues = values;
        this.size = values.length;
        this.setArrayElementType(BTypes.typeByte);
    }

    public BValueArray(double[] values) {
        this.floatValues = values;
        this.size = values.length;
        this.setArrayElementType(BTypes.typeFloat);
    }

    public BValueArray(String[] values) {
        this.stringValues = values;
        this.size = values.length;
        this.setArrayElementType(BTypes.typeString);
    }

    public BValueArray(BType type) {
        if (type.getTag() == 1) {
            this.intValues = (long[])this.newArrayInstance(Long.TYPE);
            this.setArrayElementType(type);
        } else if (type.getTag() == 6) {
            this.booleanValues = (int[])this.newArrayInstance(Integer.TYPE);
            this.setArrayElementType(type);
        } else if (type.getTag() == 2) {
            this.byteValues = (byte[])this.newArrayInstance(Byte.TYPE);
            this.setArrayElementType(type);
        } else if (type.getTag() == 3) {
            this.floatValues = (double[])this.newArrayInstance(Double.TYPE);
            this.setArrayElementType(type);
        } else if (type.getTag() == 5) {
            this.stringValues = (String[])this.newArrayInstance(String.class);
            Arrays.fill(this.stringValues, "");
            this.setArrayElementType(type);
        } else {
            this.arrayType = type;
            if (type.getTag() == 19) {
                BArrayType arrayType = (BArrayType)type;
                this.elementType = arrayType.getElementType();
                if (arrayType.getState() == BArrayState.CLOSED_SEALED) {
                    this.size = this.maxArraySize = arrayType.getSize();
                }
                this.refValues = (BRefType[])this.newArrayInstance(BRefType.class);
                Arrays.fill(this.refValues, arrayType.getElementType().getZeroValue());
            } else if (type.getTag() == 30) {
                BTupleType tupleType = (BTupleType)type;
                this.size = this.maxArraySize = tupleType.getTupleTypes().size();
                this.refValues = (BRefType[])this.newArrayInstance(BRefType.class);
                List<BType> tupleTypes = tupleType.getTupleTypes();
                for (int i = 0; i < tupleTypes.size(); ++i) {
                    this.refValues[i] = (BRefType)tupleTypes.get(i).getZeroValue();
                }
            } else {
                this.refValues = (BRefType[])this.newArrayInstance(BRefType.class);
                Arrays.fill(this.refValues, type.getZeroValue());
                this.setArrayElementType(type);
            }
        }
    }

    public BValueArray() {
        this.refValues = (BRefType[])this.newArrayInstance(BRefType.class);
    }

    public BValueArray(BType type, int size) {
        if (size != -1) {
            this.size = this.maxArraySize = size;
        }
        if (type.getTag() == 1) {
            this.intValues = (long[])this.newArrayInstance(Long.TYPE);
        } else if (type.getTag() == 6) {
            this.booleanValues = (int[])this.newArrayInstance(Integer.TYPE);
        } else if (type.getTag() == 2) {
            this.byteValues = (byte[])this.newArrayInstance(Byte.TYPE);
        } else if (type.getTag() == 3) {
            this.floatValues = (double[])this.newArrayInstance(Double.TYPE);
        } else if (type.getTag() == 4) {
            this.refValues = (BRefType[])this.newArrayInstance(BRefType.class);
            Arrays.fill(this.refValues, type.getEmptyValue());
        } else if (type.getTag() == 5) {
            this.stringValues = (String[])this.newArrayInstance(String.class);
            Arrays.fill(this.stringValues, "");
        } else {
            this.refValues = (BRefType[])this.newArrayInstance(BRefType.class);
            Arrays.fill(this.refValues, type.getZeroValue());
        }
        this.arrayType = new BArrayType(type, size);
        this.elementType = type;
    }

    public BRefType<?> getRefValue(long index) {
        this.rangeCheckForGet(index, this.size);
        return this.refValues[(int)index];
    }

    public long getInt(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.elementType.getTag() == 2) {
            return this.byteValues[(int)index];
        }
        return this.intValues[(int)index];
    }

    public int getBoolean(long index) {
        this.rangeCheckForGet(index, this.size);
        return this.booleanValues[(int)index];
    }

    public byte getByte(long index) {
        this.rangeCheckForGet(index, this.size);
        return this.byteValues[(int)index];
    }

    public double getFloat(long index) {
        this.rangeCheckForGet(index, this.size);
        return this.floatValues[(int)index];
    }

    public String getString(long index) {
        this.rangeCheckForGet(index, this.size);
        return this.stringValues[(int)index];
    }

    public void add(long index, BRefType<?> value) {
        this.prepareForAdd(index, this.refValues.length);
        this.refValues[(int)index] = value;
    }

    public void add(long index, long value) {
        this.prepareForAdd(index, this.intValues.length);
        this.intValues[(int)index] = value;
    }

    public void add(long index, int value) {
        if (this.elementType.getTag() == 1) {
            this.add(index, (long)value);
            return;
        }
        this.prepareForAdd(index, this.booleanValues.length);
        this.booleanValues[(int)index] = value;
    }

    public void add(long index, byte value) {
        this.prepareForAdd(index, this.byteValues.length);
        this.byteValues[(int)index] = value;
    }

    public void add(long index, double value) {
        this.prepareForAdd(index, this.floatValues.length);
        this.floatValues[(int)index] = value;
    }

    public void add(long index, String value) {
        this.prepareForAdd(index, this.stringValues.length);
        this.stringValues[(int)index] = value;
    }

    public void append(BRefType<?> value) {
        this.add((long)this.size, value);
    }

    @Override
    public BType getType() {
        return this.arrayType;
    }

    @Override
    public BValue copy(Map<BValue, BValue> refs) {
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        if (this.elementType != null) {
            BValueArray valueArray = null;
            if (this.elementType.getTag() == 1) {
                valueArray = new BValueArray(Arrays.copyOf(this.intValues, this.intValues.length));
            } else if (this.elementType.getTag() == 6) {
                valueArray = new BValueArray(Arrays.copyOf(this.booleanValues, this.booleanValues.length));
            } else if (this.elementType.getTag() == 2) {
                valueArray = new BValueArray(Arrays.copyOf(this.byteValues, this.byteValues.length));
            } else if (this.elementType.getTag() == 3) {
                valueArray = new BValueArray(Arrays.copyOf(this.floatValues, this.floatValues.length));
            } else if (this.elementType.getTag() == 5) {
                valueArray = new BValueArray(Arrays.copyOf(this.stringValues, this.stringValues.length));
            }
            if (valueArray != null) {
                valueArray.size = this.size;
                refs.put(this, valueArray);
                return valueArray;
            }
        }
        BRefType[] values = new BRefType[this.size];
        BValueArray refValueArray = new BValueArray(values, this.arrayType);
        refValueArray.size = this.size;
        refs.put(this, refValueArray);
        int bound = this.size;
        IntStream.range(0, bound).forEach(i -> {
            values[i] = this.refValues[i] == null ? null : (BRefType)this.refValues[i].copy(refs);
        });
        return refValueArray;
    }

    @Override
    public String stringValue() {
        StringJoiner sj;
        if (this.elementType != null) {
            sj = new StringJoiner(", ", "[", "]");
            if (this.elementType.getTag() == 1) {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Long.toString(this.intValues[i]));
                }
                return sj.toString();
            }
            if (this.elementType.getTag() == 6) {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Boolean.toString(this.booleanValues[i] == 1));
                }
                return sj.toString();
            }
            if (this.elementType.getTag() == 2) {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Long.toString(Byte.toUnsignedLong(this.byteValues[i])));
                }
                return sj.toString();
            }
            if (this.elementType.getTag() == 3) {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Double.toString(this.floatValues[i]));
                }
                return sj.toString();
            }
            if (this.elementType.getTag() == 5) {
                for (int i = 0; i < this.size; ++i) {
                    sj.add("\"" + this.stringValues[i] + "\"");
                }
                return sj.toString();
            }
        }
        if (this.getElementType(this.arrayType).getTag() == 7) {
            return this.getJSONString();
        }
        sj = new StringJoiner(", ", "[", "]");
        for (int i = 0; i < this.size; ++i) {
            if (this.refValues[i] != null) {
                sj.add(this.refValues[i].getType().getTag() == 5 ? "\"" + this.refValues[i] + "\"" : this.refValues[i].stringValue());
                continue;
            }
            sj.add("()");
        }
        return sj.toString();
    }

    @Override
    public BValue getBValue(long index) {
        if (this.elementType != null) {
            if (this.elementType.getTag() == 1) {
                return new BInteger(this.getInt(index));
            }
            if (this.elementType.getTag() == 6) {
                return new BBoolean(this.getBoolean(index) == 1);
            }
            if (this.elementType.getTag() == 2) {
                return new BByte(this.getByte(index));
            }
            if (this.elementType.getTag() == 3) {
                return new BFloat(this.getFloat(index));
            }
            if (this.elementType.getTag() == 5) {
                return new BString(this.getString(index));
            }
            return this.getRefValue(index);
        }
        return this.getRefValue(index);
    }

    public BRefType<?>[] getValues() {
        return this.refValues;
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[this.size];
        System.arraycopy(this.byteValues, 0, bytes, 0, this.size);
        return bytes;
    }

    public String[] getStringArray() {
        return this.stringValues;
    }

    public String toString() {
        return this.stringValue();
    }

    @Override
    public void grow(int newLength) {
        if (this.elementType != null) {
            switch (this.elementType.getTag()) {
                case 1: {
                    this.intValues = Arrays.copyOf(this.intValues, newLength);
                    break;
                }
                case 6: {
                    this.booleanValues = Arrays.copyOf(this.booleanValues, newLength);
                    break;
                }
                case 2: {
                    this.byteValues = Arrays.copyOf(this.byteValues, newLength);
                    break;
                }
                case 3: {
                    this.floatValues = Arrays.copyOf(this.floatValues, newLength);
                    break;
                }
                case 5: {
                    this.stringValues = Arrays.copyOf(this.stringValues, newLength);
                    Arrays.fill(this.stringValues, this.size, this.stringValues.length - 1, "");
                    break;
                }
                default: {
                    this.refValues = Arrays.copyOf(this.refValues, newLength);
                    Arrays.fill(this.refValues, this.size, this.refValues.length - 1, this.elementType.getZeroValue());
                    break;
                }
            }
        } else {
            this.refValues = Arrays.copyOf(this.refValues, newLength);
        }
    }

    public BType getArrayType() {
        return this.arrayType;
    }

    private void setArrayElementType(BType type) {
        this.arrayType = new BArrayType(type);
        this.elementType = type;
    }

    private String getJSONString() {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        JsonGenerator gen = new JsonGenerator(byteOut);
        try {
            gen.serialize(this);
            gen.flush();
        }
        catch (IOException e) {
            throw new BallerinaException("Error in converting JSON to a string: " + e.getMessage(), e);
        }
        return new String(byteOut.toByteArray());
    }

    private BType getElementType(BType type) {
        if (type.getTag() != 19) {
            return type;
        }
        return this.getElementType(((BArrayType)type).getElementType());
    }

    private boolean isBasicType(BType type) {
        return type == BTypes.typeString || type == BTypes.typeInt || type == BTypes.typeFloat || type == BTypes.typeBoolean || type == BTypes.typeByte;
    }

    private void moveBasicTypeArrayToRefValueArray() {
        int i;
        this.refValues = (BRefType[])this.newArrayInstance(BRefType.class);
        if (this.elementType == BTypes.typeBoolean) {
            i = 0;
            while ((long)i < this.size()) {
                this.refValues[i] = new BBoolean(this.booleanValues[i] == 1);
                ++i;
            }
            this.booleanValues = null;
        }
        if (this.elementType == BTypes.typeInt) {
            i = 0;
            while ((long)i < this.size()) {
                this.refValues[i] = new BInteger(this.intValues[i]);
                ++i;
            }
            this.intValues = null;
        }
        if (this.elementType == BTypes.typeString) {
            i = 0;
            while ((long)i < this.size()) {
                this.refValues[i] = new BString(this.stringValues[i]);
                ++i;
            }
            this.stringValues = null;
        }
        if (this.elementType == BTypes.typeFloat) {
            i = 0;
            while ((long)i < this.size()) {
                this.refValues[i] = new BFloat(this.floatValues[i]);
                ++i;
            }
            this.floatValues = null;
        }
        if (this.elementType == BTypes.typeByte) {
            i = 0;
            while ((long)i < this.size()) {
                this.refValues[i] = new BByte(this.byteValues[i]);
                ++i;
            }
            this.byteValues = null;
        }
        this.elementType = null;
    }

    private void moveRefValueArrayToBasicTypeArray(BType type, BType arrayElementType) {
        int i;
        BRefType<?>[] arrayValues = this.getValues();
        if (arrayElementType.getTag() == 1) {
            this.intValues = (long[])this.newArrayInstance(Long.TYPE);
            i = 0;
            while ((long)i < this.size()) {
                this.intValues[i] = ((BInteger)arrayValues[i]).value();
                ++i;
            }
        }
        if (arrayElementType.getTag() == 3) {
            this.floatValues = (double[])this.newArrayInstance(Double.TYPE);
            i = 0;
            while ((long)i < this.size()) {
                this.floatValues[i] = ((BFloat)arrayValues[i]).value();
                ++i;
            }
        }
        if (arrayElementType.getTag() == 6) {
            this.booleanValues = (int[])this.newArrayInstance(Integer.TYPE);
            i = 0;
            while ((long)i < this.size()) {
                this.booleanValues[i] = ((BBoolean)arrayValues[i]).value() != false ? 1 : 0;
                ++i;
            }
        }
        if (arrayElementType.getTag() == 5) {
            this.stringValues = (String[])this.newArrayInstance(String.class);
            i = 0;
            while ((long)i < this.size()) {
                this.stringValues[i] = arrayValues[i].stringValue();
                ++i;
            }
        }
        if (arrayElementType.getTag() == 2) {
            this.byteValues = (byte[])this.newArrayInstance(Byte.TYPE);
            i = 0;
            while ((long)i < this.size()) {
                this.byteValues[i] = ((BByte)arrayValues[i]).value().byteValue();
                ++i;
            }
        }
        this.elementType = arrayElementType;
        this.arrayType = type;
        this.refValues = null;
    }
}

