/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.util.serializer;

import org.ballerinalang.model.util.serializer.BTreeHelper;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BValue;

public class BPacket {
    private final BMap<String, BValue> map;

    private BPacket() {
        this(new BMap<String, BValue>());
    }

    private BPacket(BMap<String, BValue> map) {
        this.map = map;
    }

    static BPacket toPacket(BMap<String, BValue> map) {
        return new BPacket(map);
    }

    public static BPacket from(String type, BValue payload) {
        BPacket bPacket = new BPacket();
        bPacket.put("value#", payload);
        bPacket.put("type#", BTreeHelper.createBString(type));
        return bPacket;
    }

    public static BPacket nullObject(String typeName) {
        return BPacket.from(typeName, null).put("#null#", null);
    }

    public BMap<String, BValue> toBMap() {
        return this.map;
    }

    public BPacket put(String key, BValue item) {
        this.map.put(key, item);
        return this;
    }

    public BPacket putString(String key, String val) {
        this.map.put(key, BTreeHelper.createBString(val));
        return this;
    }

    public BValue getValue() {
        return this.map.get("value#");
    }

    public BValue get(String key) {
        return this.map.get(key);
    }
}

