/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.util.Map;
import java.util.UUID;
import org.ballerinalang.model.types.BIndexedType;
import org.ballerinalang.model.types.BStreamType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.exceptions.BallerinaException;

public class BStream
implements BRefType<Object> {
    private static final String TOPIC_NAME_PREFIX = "TOPIC_NAME_";
    private BType type;
    private BType constraintType;
    private String streamId = "";
    public String topicName;

    public BStream(BType type, String name) {
        if (((BStreamType)type).getConstrainedType() == null) {
            throw new BallerinaException("a stream cannot be declared without a constraint");
        }
        this.constraintType = ((BStreamType)type).getConstrainedType();
        this.type = new BStreamType(this.constraintType);
        this.topicName = this.constraintType instanceof BIndexedType ? TOPIC_NAME_PREFIX + ((BIndexedType)((Object)this.constraintType)).getElementType() + "_" + name : (this.constraintType != null ? TOPIC_NAME_PREFIX + this.constraintType + "_" + name : TOPIC_NAME_PREFIX + name);
        this.topicName = this.topicName.concat("_").concat(UUID.randomUUID().toString());
        this.streamId = name;
    }

    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public String stringValue() {
        return "";
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public BValue copy(Map<BValue, BValue> refs) {
        return null;
    }

    @Override
    public Object value() {
        return null;
    }

    public BType getConstraintType() {
        return this.constraintType;
    }
}

