/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.file.service;

import java.util.Map;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.stdlib.file.service.DirectoryCallback;
import org.ballerinalang.stdlib.file.utils.FileConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.localfilesystem.server.connector.contract.LocalFileSystemEvent;
import org.wso2.transport.localfilesystem.server.connector.contract.LocalFileSystemListener;

public class FSListener
implements LocalFileSystemListener {
    private static final Logger log = LoggerFactory.getLogger(FSListener.class);
    private BRuntime runtime;
    private ObjectValue service;
    private Map<String, AttachedFunction> attachedFunctionRegistry;

    public FSListener(BRuntime runtime, ObjectValue service, Map<String, AttachedFunction> resourceRegistry) {
        this.runtime = runtime;
        this.service = service;
        this.attachedFunctionRegistry = resourceRegistry;
    }

    public void onMessage(LocalFileSystemEvent fileEvent) {
        Object[] parameters = this.getJvmSignatureParameters(fileEvent);
        AttachedFunction resource = this.getAttachedFunction(fileEvent.getEvent());
        if (resource != null) {
            this.runtime.invokeMethodAsync(this.service, resource.getName(), (CallableUnitCallback)new DirectoryCallback(), parameters);
        } else {
            log.warn(String.format("FileEvent received for unregistered resource: [%s] %s", fileEvent.getEvent(), fileEvent.getFileName()));
        }
    }

    private Object[] getJvmSignatureParameters(LocalFileSystemEvent fileEvent) {
        MapValue eventStruct = BallerinaValues.createRecordValue((BPackage)FileConstants.FILE_PACKAGE_ID, (String)"FileEvent");
        eventStruct.put((Object)"name", (Object)fileEvent.getFileName());
        eventStruct.put((Object)"operation", (Object)fileEvent.getEvent());
        return new Object[]{eventStruct, true};
    }

    private AttachedFunction getAttachedFunction(String event) {
        return this.attachedFunctionRegistry.get(event);
    }
}

