/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.format;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.ballerinalang.compiler.CompilerOptionName;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.format.Messages;
import org.ballerinalang.langserver.compiler.format.FormattingVisitorEntry;
import org.ballerinalang.langserver.compiler.format.JSONGenerationException;
import org.ballerinalang.langserver.compiler.format.TextDocumentFormatUtil;
import org.ballerinalang.langserver.compiler.sourcegen.FormattingSourceGen;
import org.ballerinalang.model.tree.Node;
import org.ballerinalang.tool.BLauncherCmd;
import org.ballerinalang.tool.LauncherUtils;
import org.wso2.ballerinalang.compiler.Compiler;
import org.wso2.ballerinalang.compiler.FileSystemProgramDirectory;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerOptions;

public class FormatUtil {
    static final String CMD_NAME = "format";
    private static final PrintStream outStream = System.err;
    private static EmptyPrintStream emptyPrintStream;

    static void execute(List<String> argList, boolean helpFlag, boolean dryRun, Path sourceRootPath) {
        if (helpFlag) {
            String commandUsageInfo = BLauncherCmd.getCommandUsageInfo((String)CMD_NAME);
            outStream.println(commandUsageInfo);
            return;
        }
        if (argList != null && argList.size() > 1) {
            throw LauncherUtils.createLauncherException((String)Messages.getArgumentError());
        }
        try {
            if (argList != null && argList.size() > 0) {
                if (FormatUtil.isBalFile(argList.get(0))) {
                    String formattedSourceCode;
                    String ballerinaFilePath = argList.get(0);
                    Path filePath = Paths.get(ballerinaFilePath, new String[0]);
                    Path programDir = filePath.toAbsolutePath().getParent();
                    String fileName = filePath.toAbsolutePath().getFileName().toString();
                    if (!Files.exists(filePath, new LinkOption[0]) || Files.isDirectory(filePath, new LinkOption[0])) {
                        throw LauncherUtils.createLauncherException((String)Messages.getNoBallerinaFile(ballerinaFilePath));
                    }
                    BLangPackage bLangPackage = FormatUtil.compileFile(programDir, fileName);
                    if (bLangPackage.diagCollector.hasErrors()) {
                        return;
                    }
                    BLangCompilationUnit compilationUnit = (BLangCompilationUnit)bLangPackage.getCompilationUnits().get(0);
                    if (FormatUtil.doChangesAvailable(compilationUnit, formattedSourceCode = FormatUtil.format(compilationUnit))) {
                        if (!dryRun) {
                            FormatUtil.writeFile(filePath.toAbsolutePath().toString(), formattedSourceCode);
                            outStream.println(Messages.getModifiedFiles() + System.lineSeparator() + ballerinaFilePath);
                            outStream.println(System.lineSeparator() + Messages.getSuccessMessage());
                        } else {
                            outStream.println(Messages.getFilesToModify() + System.lineSeparator() + ballerinaFilePath);
                        }
                    } else {
                        outStream.println(Messages.getNoChanges());
                    }
                } else {
                    if (Files.isRegularFile(Paths.get(argList.get(0), new String[0]), new LinkOption[0])) {
                        throw LauncherUtils.createLauncherException((String)Messages.getNotABallerinaFile());
                    }
                    String moduleName = argList.get(0);
                    if (!FormatUtil.isModuleExist(moduleName, sourceRootPath)) {
                        if (moduleName.contains(".")) {
                            throw LauncherUtils.createLauncherException((String)Messages.getNoBallerinaModuleOrFile(moduleName));
                        }
                        throw LauncherUtils.createLauncherException((String)Messages.getNoModuleFound(moduleName));
                    }
                    if (FormatUtil.notABallerinaProject(sourceRootPath)) {
                        throw LauncherUtils.createLauncherException((String)Messages.getNotBallerinaProject());
                    }
                    BLangPackage bLangPackage = FormatUtil.compileModule(sourceRootPath, FormatUtil.getModuleName(moduleName));
                    if (bLangPackage.diagCollector.hasErrors()) {
                        return;
                    }
                    List<String> formattedFiles = FormatUtil.iterateAndFormat(bLangPackage, sourceRootPath, dryRun);
                    FormatUtil.generateChangeReport(formattedFiles, dryRun);
                }
            } else {
                if (FormatUtil.notABallerinaProject(sourceRootPath)) {
                    throw LauncherUtils.createLauncherException((String)Messages.getNotBallerinaProject());
                }
                List<BLangPackage> packages = FormatUtil.compileProject(sourceRootPath);
                boolean hasCompilationErrors = false;
                for (BLangPackage bLangPackage : packages) {
                    if (!bLangPackage.diagCollector.hasErrors()) continue;
                    hasCompilationErrors = true;
                    break;
                }
                if (hasCompilationErrors) {
                    return;
                }
                ArrayList<String> formattedFiles = new ArrayList<String>();
                for (BLangPackage bLangPackage : packages) {
                    formattedFiles.addAll(FormatUtil.iterateAndFormat(bLangPackage, sourceRootPath, dryRun));
                }
                FormatUtil.generateChangeReport(formattedFiles, dryRun);
            }
        }
        catch (IOException | NullPointerException | JSONGenerationException e) {
            throw LauncherUtils.createLauncherException((String)Messages.getException());
        }
    }

    private static boolean notABallerinaProject(Path path) {
        Path cachePath = path.resolve("Ballerina.toml");
        return !Files.exists(cachePath, new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String filePath, String content) throws IOException {
        try (OutputStreamWriter fileWriter = null;){
            File newFile = new File(filePath);
            FileOutputStream fileStream = new FileOutputStream(newFile);
            fileWriter = new OutputStreamWriter((OutputStream)fileStream, StandardCharsets.UTF_8);
            fileWriter.write(content);
        }
    }

    private static boolean isBalFile(String fileName) {
        return fileName.endsWith(".bal");
    }

    private static boolean isModuleExist(String module, Path projectRoot) {
        Path modulePath = module.startsWith("src/") ? projectRoot.resolve(module) : projectRoot.resolve("src").resolve(module);
        return Files.isDirectory(modulePath, new LinkOption[0]);
    }

    private static List<BLangPackage> compileProject(Path sourceRoot) throws UnsupportedEncodingException {
        emptyPrintStream = new EmptyPrintStream();
        CompilerContext context = FormatUtil.getCompilerContext(sourceRoot);
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        compiler.setOutStream((PrintStream)emptyPrintStream);
        return compiler.compilePackages(false);
    }

    private static BLangPackage compileModule(Path sourceRoot, String moduleName) throws UnsupportedEncodingException {
        emptyPrintStream = new EmptyPrintStream();
        CompilerContext context = FormatUtil.getCompilerContext(sourceRoot);
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        compiler.setOutStream((PrintStream)emptyPrintStream);
        return compiler.compile(moduleName);
    }

    private static BLangPackage compileFile(Path sourceRoot, String packageName) throws UnsupportedEncodingException {
        emptyPrintStream = new EmptyPrintStream();
        CompilerContext context = FormatUtil.getCompilerContext(sourceRoot);
        context.put(SourceDirectory.class, (Object)new FileSystemProgramDirectory(sourceRoot));
        Compiler compiler = Compiler.getInstance((CompilerContext)context);
        compiler.setOutStream((PrintStream)emptyPrintStream);
        return compiler.compile(packageName);
    }

    private static CompilerContext getCompilerContext(Path sourceRootPath) {
        CompilerPhase compilerPhase = CompilerPhase.DEFINE;
        CompilerContext context = new CompilerContext();
        CompilerOptions options = CompilerOptions.getInstance((CompilerContext)context);
        options.put(CompilerOptionName.PROJECT_DIR, sourceRootPath.toString());
        options.put(CompilerOptionName.OFFLINE, Boolean.toString(false));
        options.put(CompilerOptionName.COMPILER_PHASE, compilerPhase.toString());
        options.put(CompilerOptionName.SKIP_TESTS, Boolean.toString(false));
        options.put(CompilerOptionName.TEST_ENABLED, "true");
        options.put(CompilerOptionName.LOCK_ENABLED, Boolean.toString(false));
        options.put(CompilerOptionName.EXPERIMENTAL_FEATURES_ENABLED, Boolean.toString(true));
        options.put(CompilerOptionName.PRESERVE_WHITESPACE, Boolean.toString(true));
        return context;
    }

    private static String format(BLangCompilationUnit compilationUnit) throws JSONGenerationException {
        JsonElement modelElement = TextDocumentFormatUtil.generateJSON((Node)compilationUnit, new HashMap(), new HashMap());
        JsonObject model = modelElement.getAsJsonObject();
        FormattingSourceGen.build((JsonObject)model, (String)"CompilationUnit");
        FormattingVisitorEntry formattingUtil = new FormattingVisitorEntry();
        formattingUtil.accept(model);
        return FormattingSourceGen.getSourceOf((JsonObject)model);
    }

    private static boolean doChangesAvailable(BLangCompilationUnit compilationUnit, String formattedSource) throws JSONGenerationException {
        JsonElement modelElement = TextDocumentFormatUtil.generateJSON((Node)compilationUnit, new HashMap(), new HashMap());
        JsonObject model = modelElement.getAsJsonObject();
        FormattingSourceGen.build((JsonObject)model, (String)"CompilationUnit");
        String originalSource = FormattingSourceGen.getSourceOf((JsonObject)model);
        return !originalSource.equals(formattedSource);
    }

    private static List<String> iterateAndFormat(BLangPackage bLangPackage, Path sourceRootPath, boolean dryRun) throws IOException, JSONGenerationException {
        ArrayList<String> formattedFiles = new ArrayList<String>();
        for (BLangCompilationUnit compilationUnit : bLangPackage.getCompilationUnits()) {
            FormatUtil.formatAndWrite(compilationUnit, sourceRootPath, formattedFiles, dryRun);
        }
        for (BLangTestablePackage testablePackage : bLangPackage.getTestablePkgs()) {
            for (BLangCompilationUnit compilationUnit : testablePackage.getCompilationUnits()) {
                FormatUtil.formatAndWrite(compilationUnit, sourceRootPath, formattedFiles, dryRun);
            }
        }
        return formattedFiles;
    }

    private static void formatAndWrite(BLangCompilationUnit compilationUnit, Path sourceRootPath, List<String> formattedFiles, boolean dryRun) throws JSONGenerationException, IOException {
        String fileName = sourceRootPath.toString() + File.separator + "src" + File.separator + compilationUnit.getPosition().getSource().getPackageName() + File.separator + compilationUnit.getPosition().getSource().getCompilationUnitName();
        String formattedSource = FormatUtil.format(compilationUnit);
        if (FormatUtil.doChangesAvailable(compilationUnit, formattedSource)) {
            if (!dryRun) {
                FormatUtil.writeFile(fileName, formattedSource);
            }
            formattedFiles.add(fileName);
        }
    }

    private static void generateChangeReport(List<String> formattedFiles, boolean dryRun) {
        if (formattedFiles.size() > 0) {
            StringBuilder fileList = new StringBuilder();
            if (dryRun) {
                fileList.append(Messages.getFilesToModify()).append(System.lineSeparator());
            } else {
                fileList.append(Messages.getModifiedFiles()).append(System.lineSeparator());
            }
            for (String file : formattedFiles) {
                fileList.append(file).append(System.lineSeparator());
            }
            outStream.println(fileList.toString());
            if (!dryRun) {
                outStream.println(Messages.getSuccessMessage());
            }
        } else {
            outStream.println(Messages.getNoChanges());
        }
    }

    private static String getModuleName(String moduleName) {
        String pattern = Pattern.quote(File.separator);
        String[] splitedTokens = moduleName.split(pattern);
        return splitedTokens[splitedTokens.length - 1];
    }

    static class EmptyPrintStream
    extends PrintStream {
        EmptyPrintStream() throws UnsupportedEncodingException {
            super(new OutputStream(){

                @Override
                public void write(int b) {
                }
            }, true, "UTF-8");
        }
    }
}

