/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import com.google.protobuf.Descriptors;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.util.HashMap;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageRegistry;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.builder.utils.BalGenConstants;
import org.ballerinalang.net.grpc.exception.GrpcServerException;
import org.ballerinalang.net.grpc.interceptor.ServerHeaderInterceptor;
import org.ballerinalang.net.grpc.listener.BidirectionalStreamingListener;
import org.ballerinalang.net.grpc.listener.ClientStreamingListener;
import org.ballerinalang.net.grpc.listener.ServerStreamingListener;
import org.ballerinalang.net.grpc.listener.UnaryMethodListener;
import org.ballerinalang.net.grpc.proto.ServiceProtoUtils;
import org.wso2.transport.http.netty.config.ListenerConfiguration;

public class GrpcServicesBuilder {
    public static ServerBuilder initService(ListenerConfiguration serviceEndpointConfig, SslContext sslContext) {
        NettyServerBuilder serverBuilder = sslContext != null ? NettyServerBuilder.forPort((int)serviceEndpointConfig.getPort()).bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(Runtime.getRuntime().availableProcessors())).workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2)).sslContext(sslContext) : NettyServerBuilder.forPort((int)serviceEndpointConfig.getPort()).bossEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(Runtime.getRuntime().availableProcessors())).workerEventLoopGroup((EventLoopGroup)new NioEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2));
        return serverBuilder;
    }

    public static void registerService(ServerBuilder serverBuilder, Service service) throws GrpcServerException {
        try {
            serverBuilder.addService(ServerInterceptors.intercept((ServerServiceDefinition)GrpcServicesBuilder.getServiceDefinition(service), (ServerInterceptor[])new ServerInterceptor[]{new ServerHeaderInterceptor()}));
        }
        catch (GrpcServerException e) {
            throw new GrpcServerException("Error while registering the service : " + service.getName(), e);
        }
    }

    private static ServerServiceDefinition getServiceDefinition(Service service) throws GrpcServerException {
        Descriptors.FileDescriptor fileDescriptor = ServiceProtoUtils.getDescriptor(service);
        Descriptors.ServiceDescriptor serviceDescriptor = fileDescriptor.findServiceByName(service.getName());
        return GrpcServicesBuilder.getServiceDefinition(service, serviceDescriptor);
    }

    private static ServerServiceDefinition getServiceDefinition(Service service, Descriptors.ServiceDescriptor serviceDescriptor) {
        String serviceName = ".".equals(service.getPackage()) ? service.getName() : service.getPackage() + "." + service.getName();
        ServerServiceDefinition.Builder serviceDefBuilder = ServerServiceDefinition.builder((String)serviceName);
        for (Descriptors.MethodDescriptor methodDescriptor : serviceDescriptor.getMethods()) {
            ServerCallHandler serverCallHandler;
            MethodDescriptor.MethodType methodType;
            String methodName = serviceName + BalGenConstants.FILE_SEPARATOR + methodDescriptor.getName();
            Descriptors.Descriptor requestDescriptor = serviceDescriptor.findMethodByName(methodDescriptor.getName()).getInputType();
            Descriptors.Descriptor responseDescriptor = serviceDescriptor.findMethodByName(methodDescriptor.getName()).getOutputType();
            MessageRegistry messageRegistry = MessageRegistry.getInstance();
            messageRegistry.addMessageDescriptor(requestDescriptor.getName(), requestDescriptor);
            MessageUtils.setNestedMessages(requestDescriptor, messageRegistry);
            messageRegistry.addMessageDescriptor(responseDescriptor.getName(), responseDescriptor);
            MessageUtils.setNestedMessages(responseDescriptor, messageRegistry);
            MethodDescriptor.Marshaller reqMarshaller = ProtoUtils.marshaller((com.google.protobuf.Message)Message.newBuilder(requestDescriptor.getName()).build());
            MethodDescriptor.Marshaller resMarshaller = ProtoUtils.marshaller((com.google.protobuf.Message)Message.newBuilder(responseDescriptor.getName()).build());
            HashMap<String, Resource> resourceMap = new HashMap<String, Resource>();
            Resource mappedResource = null;
            for (Resource resource : service.getResources()) {
                if (methodDescriptor.getName().equals(resource.getName())) {
                    mappedResource = resource;
                }
                resourceMap.put(resource.getName(), resource);
            }
            if (methodDescriptor.toProto().getServerStreaming() && methodDescriptor.toProto().getClientStreaming()) {
                methodType = MethodDescriptor.MethodType.BIDI_STREAMING;
                serverCallHandler = ServerCalls.asyncBidiStreamingCall((ServerCalls.BidiStreamingMethod)new BidirectionalStreamingListener(methodDescriptor, resourceMap));
            } else if (methodDescriptor.toProto().getClientStreaming()) {
                methodType = MethodDescriptor.MethodType.CLIENT_STREAMING;
                serverCallHandler = ServerCalls.asyncClientStreamingCall((ServerCalls.ClientStreamingMethod)new ClientStreamingListener(methodDescriptor, resourceMap));
            } else if (methodDescriptor.toProto().getServerStreaming()) {
                methodType = MethodDescriptor.MethodType.SERVER_STREAMING;
                serverCallHandler = ServerCalls.asyncServerStreamingCall((ServerCalls.ServerStreamingMethod)new ServerStreamingListener(methodDescriptor, mappedResource));
            } else {
                methodType = MethodDescriptor.MethodType.UNARY;
                serverCallHandler = ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new UnaryMethodListener(methodDescriptor, mappedResource));
            }
            MethodDescriptor.Builder methodBuilder = MethodDescriptor.newBuilder();
            MethodDescriptor grpcMethodDescriptor = methodBuilder.setType(methodType).setFullMethodName(methodName).setRequestMarshaller(reqMarshaller).setResponseMarshaller(resMarshaller).setSchemaDescriptor((Object)methodDescriptor).build();
            serviceDefBuilder.addMethod(grpcMethodDescriptor, serverCallHandler);
        }
        return serviceDefBuilder.build();
    }

    public static Server start(ServerBuilder serverBuilder) throws GrpcServerException {
        if (serverBuilder == null) {
            throw new GrpcServerException("Error occurred while starting gRPC server. Please check server configurations");
        }
        Server server = serverBuilder.build();
        if (server != null) {
            try {
                server.start();
            }
            catch (IOException e) {
                throw new GrpcServerException("Failed to start gRPC server. " + e.getMessage(), e);
            }
        } else {
            throw new GrpcServerException("No gRPC service is registered to Start. You need to Register the service");
        }
        return server;
    }

    public static void stop(Server server) {
        if (server != null) {
            server.shutdown();
        }
    }

    public static void blockUntilShutdown(Server server) throws InterruptedException {
        if (server != null) {
            server.awaitTermination();
        }
    }
}

