/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import com.google.protobuf.Descriptors;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MessageRegistry {
    private Map<String, Descriptors.Descriptor> messageDescriptors = new HashMap<String, Descriptors.Descriptor>();
    private Map<String, Descriptors.MethodDescriptor> methodDescriptors = new HashMap<String, Descriptors.MethodDescriptor>();
    private static volatile MessageRegistry messageRegistry = new MessageRegistry();

    private MessageRegistry() {
    }

    public static MessageRegistry getInstance() {
        return messageRegistry;
    }

    void addMessageDescriptor(String messageName, Descriptors.Descriptor messageDescriptor) {
        this.messageDescriptors.put(messageName, messageDescriptor);
    }

    public Descriptors.Descriptor getMessageDescriptor(String messageName) {
        return this.messageDescriptors.get(messageName);
    }

    public Map<String, Descriptors.Descriptor> getMessageDescriptorMap() {
        return Collections.unmodifiableMap(this.messageDescriptors);
    }

    public Descriptors.MethodDescriptor getMethodDescriptor(String messageName) {
        return this.methodDescriptors.get(messageName);
    }

    public Map<String, Descriptors.MethodDescriptor> getMethodDescriptorMap() {
        return Collections.unmodifiableMap(this.methodDescriptors);
    }

    void addMethodDescriptor(String methodName, Descriptors.MethodDescriptor methodDescriptor) {
        this.methodDescriptors.put(methodName, methodDescriptor);
    }
}

