/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.components;

import com.google.protobuf.DescriptorProtos;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.net.grpc.builder.components.ClientBuilder;
import org.ballerinalang.net.grpc.builder.components.Descriptor;
import org.ballerinalang.net.grpc.builder.utils.BalGenerationUtils;

public class DescriptorBuilder {
    private byte[] rootDescriptor;
    private List<byte[]> dependentDescriptors;
    private String key;
    private ClientBuilder clientStubBal;

    public DescriptorBuilder(List<byte[]> dependentDescriptors, String key, ClientBuilder clientStubBal) {
        this.dependentDescriptors = dependentDescriptors;
        this.key = key;
        this.clientStubBal = clientStubBal;
    }

    public void buildMap() throws IOException {
        ByteArrayInputStream targetStream = new ByteArrayInputStream(this.rootDescriptor);
        DescriptorProtos.FileDescriptorProto fileDescriptorSet = DescriptorProtos.FileDescriptorProto.parseFrom((InputStream)targetStream);
        BMap descriptorMap = new BMap();
        if (!"".equals(fileDescriptorSet.getPackage())) {
            descriptorMap.put((Object)(fileDescriptorSet.getPackage() + "." + fileDescriptorSet.getName()), (BValue)new BString(BalGenerationUtils.bytesToHex(this.rootDescriptor)));
        } else {
            descriptorMap.put((Object)fileDescriptorSet.getName(), (BValue)new BString(BalGenerationUtils.bytesToHex(this.rootDescriptor)));
        }
        for (byte[] str : this.dependentDescriptors) {
            if (str.length <= 0) continue;
            targetStream = new ByteArrayInputStream(str);
            fileDescriptorSet = DescriptorProtos.FileDescriptorProto.parseFrom((InputStream)targetStream);
            descriptorMap.put((Object)(fileDescriptorSet.getPackage() + "." + fileDescriptorSet.getName()), (BValue)new BString(BalGenerationUtils.bytesToHex(str)));
        }
        int i = 0;
        for (Object key : descriptorMap.keySet()) {
            Descriptor descriptor = i != descriptorMap.keySet().size() - 1 ? new Descriptor((String)key, ((BString)descriptorMap.get((Object)((String)key))).stringValue(), ",") : new Descriptor((String)key, ((BString)descriptorMap.get((Object)((String)key))).stringValue(), null);
            this.clientStubBal.addDescriptor(descriptor);
            ++i;
        }
    }

    public void buildKey() {
        this.clientStubBal.setRootDescriptorKey(this.key);
    }

    public void setRootDescriptor(byte[] rootDescriptor) {
        this.rootDescriptor = new byte[rootDescriptor.length];
        this.rootDescriptor = Arrays.copyOf(rootDescriptor, rootDescriptor.length);
    }
}

