/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.utils;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.FieldValueResolver;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.jknack.handlebars.io.ClassPathTemplateLoader;
import com.github.jknack.handlebars.io.FileTemplateLoader;
import com.github.jknack.handlebars.io.TemplateLoader;
import com.google.protobuf.DescriptorProtos;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.net.grpc.exception.UnsupportedFieldTypeException;

public class BalGenerationUtils {
    private static final String TEMPLATES_SUFFIX = ".mustache";
    private static final String TEMPLATES_DIR_PATH_KEY = "templates.dir.path";
    private static final String DEFAULT_TEMPLATE_DIR = File.separator + "templates";
    public static final String DEFAULT_SKELETON_DIR = DEFAULT_TEMPLATE_DIR + File.separator + "skeleton";
    public static final String DEFAULT_SAMPLE_DIR = DEFAULT_TEMPLATE_DIR + File.separator + "skeleton";
    public static final String SKELETON_TEMPLATE_NAME = "clientStub";
    public static final String SAMPLE_TEMPLATE_NAME = "sample";

    public static String bytesToHex(byte[] data) {
        char[] hexChars = new char[data.length * 2];
        for (int j = 0; j < data.length; ++j) {
            int v = data[j] & 0xFF;
            hexChars[j * 2] = "0123456789ABCDEF".toCharArray()[v >>> 4];
            hexChars[j * 2 + 1] = "0123456789ABCDEF".toCharArray()[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String getMappingBalType(String protoType) {
        switch (protoType) {
            case "DoubleValue": 
            case "FloatValue": {
                return "float";
            }
            case "Int32Value": 
            case "Int64Value": 
            case "UInt64Value": 
            case "UInt32Value": {
                return "int";
            }
            case "BoolValue": {
                return "boolean";
            }
            case "StringValue": {
                return "string";
            }
            case "BytesValue": {
                return "blob";
            }
        }
        return protoType;
    }

    public static void writeFile(String payload, Path balOutPath) throws FileNotFoundException, UnsupportedEncodingException {
        PrintWriter writer = new PrintWriter(balOutPath.toFile(), "UTF-8");
        writer.print(payload);
        writer.close();
    }

    public static Map<String, DescriptorProtos.DescriptorProto> attributeListToMap(List<DescriptorProtos.DescriptorProto> list) {
        HashMap<String, DescriptorProtos.DescriptorProto> stringObjectMap = new HashMap<String, DescriptorProtos.DescriptorProto>();
        for (DescriptorProtos.DescriptorProto proto : list) {
            stringObjectMap.put(proto.getName(), proto);
        }
        return stringObjectMap;
    }

    public static String getTypeName(int num) {
        switch (num) {
            case 1: {
                return "float";
            }
            case 2: {
                return "float";
            }
            case 3: 
            case 4: 
            case 6: {
                return "int";
            }
            case 5: 
            case 7: {
                return "struct";
            }
            case 8: {
                return "boolean";
            }
            case 9: {
                return "string";
            }
            case 11: {
                return "struct";
            }
        }
        throw new UnsupportedFieldTypeException("Error while decoding request message. Field type is not supported : " + num);
    }

    public static String getLabelName(int num) {
        switch (num) {
            case 3: {
                return "[]";
            }
            case 1: {
                return null;
            }
            case 2: {
                throw new UnsupportedFieldTypeException("Required type is not supported yet." + num);
            }
        }
        throw new UnsupportedFieldTypeException("Error while decoding request message. Field label is not supported : " + num);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeBallerina(Object object, String templateDir, String templateName, String outPath) throws IOException {
        try (PrintWriter writer = null;){
            Template template = BalGenerationUtils.compileTemplate(templateDir, templateName);
            Context context = Context.newBuilder((Object)object).resolver(new ValueResolver[]{FieldValueResolver.INSTANCE}).build();
            writer = new PrintWriter(outPath, "UTF-8");
            writer.println(template.apply(context));
        }
    }

    private static Template compileTemplate(String defaultTemplateDir, String templateName) throws IOException {
        String templatesDirPath = System.getProperty(TEMPLATES_DIR_PATH_KEY, defaultTemplateDir);
        ClassPathTemplateLoader cpTemplateLoader = new ClassPathTemplateLoader(templatesDirPath);
        FileTemplateLoader fileTemplateLoader = new FileTemplateLoader(templatesDirPath);
        cpTemplateLoader.setSuffix(TEMPLATES_SUFFIX);
        fileTemplateLoader.setSuffix(TEMPLATES_SUFFIX);
        Handlebars handlebars = new Handlebars().with(new TemplateLoader[]{cpTemplateLoader, fileTemplateLoader});
        handlebars.registerHelpers(StringHelpers.class);
        handlebars.registerHelper("equals", (object, options) -> {
            Object param0 = options.param(0);
            if (param0 == null) {
                throw new IllegalArgumentException("found n'null', expected 'string'");
            }
            CharSequence result = object != null && object.toString().equals(param0.toString()) ? options.fn(options.context) : null;
            return result;
        });
        return handlebars.compile(templateName);
    }
}

