/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.interceptor;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.util.Iterator;
import org.ballerinalang.net.grpc.MessageHeaders;

public class ServerHeaderInterceptor
implements ServerInterceptor {
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        MessageHeaders ctx = this.readRequestHeaders(headers);
        if (ctx != null) {
            return Contexts.interceptCall((Context)Context.current().withValue(MessageHeaders.DATA_KEY, (Object)ctx), new HeaderForwardingServerCall<ReqT, RespT>(call), (Metadata)headers, next);
        }
        return next.startCall(new HeaderForwardingServerCall<ReqT, RespT>(call), headers);
    }

    private Metadata getResponseHeaders(Metadata headers, MessageHeaders metadata) {
        for (String headerKey : metadata.keys()) {
            Metadata.Key key;
            if (headerKey.endsWith("-bin")) {
                key = Metadata.Key.of((String)headerKey, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
                byte[] byteValues = (byte[])metadata.get(key);
                headers.put(key, (Object)byteValues);
                continue;
            }
            key = Metadata.Key.of((String)headerKey, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
            String headerValue = (String)metadata.get(key);
            headers.put(key, (Object)headerValue);
        }
        return headers;
    }

    private MessageHeaders readRequestHeaders(Metadata headers) {
        MessageHeaders ctx = MessageHeaders.isPresent() ? (MessageHeaders)MessageHeaders.DATA_KEY.get() : new MessageHeaders();
        boolean found = false;
        for (String keyName : headers.keys()) {
            Iterable values;
            Metadata.Key key;
            if (keyName.endsWith("-bin")) {
                key = Metadata.Key.of((String)keyName, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
                values = headers.getAll(key);
                if (values == null) continue;
                if (ctx.containsKey(key)) {
                    ctx.removeAll(key);
                }
                for (Object value : values) {
                    ctx.put(key, value);
                }
            } else {
                key = Metadata.Key.of((String)keyName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
                values = headers.getAll(key);
                if (values == null) continue;
                if (ctx.containsKey(key)) {
                    ctx.removeAll(key);
                }
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    Object value;
                    value = (String)iterator.next();
                    ctx.put(key, value);
                }
            }
            found = true;
        }
        return found ? ctx : null;
    }

    private class HeaderForwardingServerCall<ReqT, RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        HeaderForwardingServerCall(ServerCall<ReqT, RespT> delegate) {
            super(delegate);
        }

        public void sendHeaders(Metadata headers) {
            Metadata responseHeaders = new Metadata();
            if (MessageHeaders.isPresent()) {
                MessageHeaders metadata = (MessageHeaders)MessageHeaders.DATA_KEY.get();
                headers.merge(ServerHeaderInterceptor.this.getResponseHeaders(responseHeaders, metadata));
            }
            super.sendHeaders(headers);
        }
    }
}

