/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.servicestub;

import com.google.protobuf.Descriptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.ballerinalang.bre.Context;
import org.ballerinalang.connector.api.BLangConnectorSPIUtil;
import org.ballerinalang.model.types.BTupleType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.natives.annotations.ReturnType;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageHeaders;
import org.ballerinalang.net.grpc.MessageRegistry;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.exception.GrpcClientException;
import org.ballerinalang.net.grpc.nativeimpl.servicestub.AbstractExecute;
import org.ballerinalang.net.grpc.stubs.GrpcBlockingStub;
import org.ballerinalang.util.codegen.ProgramFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="blockingExecute", receiver=@Receiver(type=TypeKind.STRUCT, structType="Stub", structPackage="ballerina.grpc"), args={@Argument(name="methodID", type=TypeKind.STRING), @Argument(name="payload", type=TypeKind.ANY), @Argument(name="headers", type=TypeKind.STRUCT, structType="Headers", structPackage="ballerina.grpc")}, returnType={@ReturnType(type=TypeKind.ANY), @ReturnType(type=TypeKind.STRUCT, structType="error", structPackage="ballerina.builtin")}, isPublic=true)
public class BlockingExecute
extends AbstractExecute {
    private static final Logger LOG = LoggerFactory.getLogger(BlockingExecute.class);
    private static final int MESSAGE_HEADER_REF_INDEX = 2;
    private static final BTupleType respTupleType = new BTupleType(Arrays.asList(BTypes.typeAny, BTypes.typeAny));

    public void execute(Context context) {
        String methodName;
        BStruct serviceStub = (BStruct)context.getRefArgument(0);
        if (serviceStub == null) {
            this.notifyErrorReply(context, "Error while getting connector. gRPC service stub is not initialized properly");
            return;
        }
        Object connectionStub = serviceStub.getNativeData("Stub");
        if (connectionStub == null) {
            this.notifyErrorReply(context, "Error while getting connection stub. gRPC Client connector is not initialized properly");
        }
        if ((methodName = context.getStringArgument(0)) == null) {
            this.notifyErrorReply(context, "Error while processing the request. RPC endpoint doesn't set properly");
            return;
        }
        Map methodDescriptors = (Map)serviceStub.getNativeData("MethodDescriptors");
        if (methodDescriptors == null) {
            this.notifyErrorReply(context, "Error while processing the request. method descriptors doesn't set properly");
            return;
        }
        Descriptors.MethodDescriptor methodDescriptor = MessageRegistry.getInstance().getMethodDescriptor(methodName);
        if (methodDescriptor == null) {
            this.notifyErrorReply(context, "No registered method descriptor for '" + methodName + "'");
            return;
        }
        BValue headerValues = context.getNullableRefArgument(2);
        MessageHeaders headers = MessageUtils.getMessageHeaders(headerValues);
        if (connectionStub instanceof GrpcBlockingStub) {
            BValue payloadBValue = context.getRefArgument(1);
            Message requestMsg = MessageUtils.generateProtoMessage(payloadBValue, methodDescriptor.getInputType());
            GrpcBlockingStub grpcBlockingStub = (GrpcBlockingStub)((Object)connectionStub);
            try {
                MethodDescriptor.MethodType methodType = this.getMethodType(methodDescriptor);
                if (methodType.equals((Object)MethodDescriptor.MethodType.UNARY)) {
                    AtomicReference headerCapture = new AtomicReference();
                    AtomicReference trailerCapture = new AtomicReference();
                    if (headers != null) {
                        grpcBlockingStub = (GrpcBlockingStub)MetadataUtils.attachHeaders((AbstractStub)grpcBlockingStub, (Metadata)headers.getMessageMetadata());
                    }
                    grpcBlockingStub = (GrpcBlockingStub)MetadataUtils.captureMetadata((AbstractStub)grpcBlockingStub, headerCapture, trailerCapture);
                    Message responseMsg = grpcBlockingStub.executeUnary(requestMsg, (MethodDescriptor<Message, Message>)((MethodDescriptor)methodDescriptors.get(methodName)));
                    Descriptors.Descriptor outputDescriptor = methodDescriptor.getOutputType();
                    BValue responseBValue = MessageUtils.generateRequestStruct(responseMsg, context.getProgramFile(), outputDescriptor.getName(), this.getBalType(outputDescriptor.getName(), context));
                    BStruct headerStruct = BLangConnectorSPIUtil.createBStruct((ProgramFile)context.getProgramFile(), (String)"ballerina.grpc", (String)"Headers", (Object[])new Object[0]);
                    Metadata respMetadata = (Metadata)headerCapture.get();
                    if (respMetadata != null) {
                        headerStruct.addNativeData("Metadata", (Object)new MessageHeaders(respMetadata));
                    }
                    BRefValueArray contentTuple = new BRefValueArray((BType)respTupleType);
                    contentTuple.add(0L, (BRefType)responseBValue);
                    contentTuple.add(1L, (BRefType)headerStruct);
                    context.setReturnValues(new BValue[]{contentTuple});
                    return;
                }
                this.notifyErrorReply(context, "Error while executing the client call. Method type " + methodType.name() + " not supported");
            }
            catch (RuntimeException | GrpcClientException e) {
                this.notifyErrorReply(context, "gRPC Client Connector Error :" + e.getMessage());
            }
        }
        this.notifyErrorReply(context, "Error while processing the request message. Connection Sub type not supported");
    }
}

