/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.servicestub;

import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Map;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BlockingNativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.ServiceDefinition;
import org.ballerinalang.net.grpc.exception.GrpcClientException;
import org.ballerinalang.net.grpc.stubs.GrpcBlockingStub;
import org.ballerinalang.net.grpc.stubs.GrpcNonBlockingStub;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="initStub", receiver=@Receiver(type=TypeKind.STRUCT, structType="Stub", structPackage="ballerina.grpc"), args={@Argument(name="clientEndpoint", type=TypeKind.STRUCT, structPackage="ballerina.grpc", structType="Client"), @Argument(name="stubType", type=TypeKind.STRING), @Argument(name="descriptorKey", type=TypeKind.STRING), @Argument(name="descriptorMap", type=TypeKind.MAP)}, isPublic=true)
public class InitStub
extends BlockingNativeCallableUnit {
    public void execute(Context context) {
        BStruct serviceStub = (BStruct)context.getRefArgument(0);
        BStruct clientEndpoint = (BStruct)context.getRefArgument(1);
        Channel channel = (Channel)clientEndpoint.getNativeData("channel");
        String stubType = context.getStringArgument(0);
        String descriptorKey = context.getStringArgument(1);
        BMap descriptorMap = (BMap)context.getRefArgument(2);
        if (stubType == null || descriptorKey == null || descriptorMap == null) {
            context.setError(MessageUtils.getConnectorError(context, (Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.INTERNAL.getCode()).withDescription("Error while initializing connector. message descriptor keys not exist. Please check the generated sub file"))));
            return;
        }
        try {
            ArrayList<byte[]> dependentDescriptors = new ArrayList<byte[]>();
            byte[] fileDescriptor = null;
            for (String key : descriptorMap.keySet()) {
                if (descriptorMap.get((Object)key) == null) continue;
                if (descriptorKey.equals(key)) {
                    fileDescriptor = InitStub.hexStringToByteArray(descriptorMap.get((Object)key).stringValue());
                    continue;
                }
                dependentDescriptors.add(InitStub.hexStringToByteArray(descriptorMap.get((Object)key).stringValue()));
            }
            if (fileDescriptor == null) {
                context.setError(MessageUtils.getConnectorError(context, (Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.INTERNAL.getCode()).withDescription("Error while establishing the connection. service descriptor is null."))));
                return;
            }
            ServiceDefinition serviceDefinition = new ServiceDefinition(fileDescriptor, dependentDescriptors);
            Map<String, MethodDescriptor<Message, Message>> methodDescriptorMap = serviceDefinition.getMethodDescriptors();
            serviceStub.addNativeData("MethodDescriptors", methodDescriptorMap);
            if ("blocking".equalsIgnoreCase(stubType)) {
                GrpcBlockingStub grpcBlockingStub = new GrpcBlockingStub(channel);
                serviceStub.addNativeData("Stub", (Object)grpcBlockingStub);
            } else if ("non-blocking".equalsIgnoreCase(stubType)) {
                GrpcNonBlockingStub nonBlockingStub = new GrpcNonBlockingStub(channel);
                serviceStub.addNativeData("Stub", (Object)nonBlockingStub);
            } else {
                context.setError(MessageUtils.getConnectorError(context, (Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.INTERNAL.getCode()).withDescription("Error while initializing connector. invalid connector type"))));
                return;
            }
            serviceStub.addNativeData("clientEndpoint", (Object)clientEndpoint);
        }
        catch (RuntimeException | GrpcClientException e) {
            context.setError(MessageUtils.getConnectorError(context, (Throwable)e));
        }
    }

    private static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

