/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.proto;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.net.grpc.config.ServiceConfiguration;
import org.ballerinalang.net.grpc.proto.ServiceProtoUtils;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.tree.BLangResource;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class ServiceDefinitionValidator {
    public static final int COMPULSORY_PARAM_COUNT = 1;
    private static final String ENDPOINT_TYPE = "ballerina.grpc:Listener";

    public static boolean validate(ServiceNode serviceNode, DiagnosticLog dlog) {
        return ServiceDefinitionValidator.validateAnnotation(serviceNode, dlog) && ServiceDefinitionValidator.validateResource(serviceNode, dlog);
    }

    private static boolean validateAnnotation(ServiceNode serviceNode, DiagnosticLog dlog) {
        List annotations = serviceNode.getAnnotationAttachments();
        List annVals = new ArrayList();
        int count = 0;
        for (AnnotationAttachmentNode annotation : annotations) {
            if (!annotation.getAnnotationName().getValue().equals("ServiceConfig") || annotation.getExpression() == null) continue;
            annVals = ((BLangRecordLiteral)annotation.getExpression()).keyValuePairs;
            ++count;
        }
        if (count > 1) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"There cannot be more than one resource annotations");
            return false;
        }
        if (count == 1) {
            boolean isNameExists = false;
            boolean clientStreaming = false;
            for (BLangRecordLiteral.BLangRecordKeyValue keyValue : annVals) {
                switch (((BLangSimpleVarRef)keyValue.key.expr).variableName.getValue()) {
                    case "name": {
                        isNameExists = true;
                        break;
                    }
                    case "clientStreaming": {
                        clientStreaming = true;
                        break;
                    }
                }
            }
            return isNameExists && clientStreaming;
        }
        return true;
    }

    private static boolean validateResource(ServiceNode serviceNode, DiagnosticLog dlog) {
        List resources = serviceNode.getResources();
        ServiceConfiguration serviceConfig = ServiceProtoUtils.getServiceConfiguration(serviceNode);
        if (serviceConfig.getRpcEndpoint() != null && serviceConfig.isClientStreaming()) {
            if (resources.size() != 4) {
                dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"There should be four resources defined in client/bidirectional streaming services");
                return false;
            }
            boolean onMessageExists = false;
            boolean onOpenExists = false;
            boolean onErrorExists = false;
            boolean onCompleteExists = false;
            for (BLangResource resourceNode : resources) {
                switch (resourceNode.getName().getValue()) {
                    case "onOpen": {
                        onOpenExists = true;
                        break;
                    }
                    case "onMessage": {
                        onMessageExists = true;
                        break;
                    }
                    case "onError": {
                        onErrorExists = true;
                        break;
                    }
                    case "onComplete": {
                        onCompleteExists = true;
                        break;
                    }
                }
                if (ServiceDefinitionValidator.validateResourceSignature(resourceNode.getParameters(), dlog, resourceNode.pos)) continue;
                return false;
            }
            if (onMessageExists && onOpenExists && onErrorExists && onCompleteExists) {
                return true;
            }
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"One or more resources(onOpen/onMessage/onError/onComplete) is not implemented in client/bidirectional streaming service");
            return false;
        }
        boolean onMessageExists = false;
        boolean onErrorExists = false;
        boolean onCompleteExists = false;
        for (BLangResource resourceNode : resources) {
            switch (resourceNode.getName().getValue()) {
                case "onMessage": {
                    onMessageExists = true;
                    break;
                }
                case "onError": {
                    onErrorExists = true;
                    break;
                }
                case "onComplete": {
                    onCompleteExists = true;
                    break;
                }
            }
        }
        if (onMessageExists && onErrorExists && onCompleteExists) {
            dlog.logDiagnostic(Diagnostic.Kind.NOTE, serviceNode.getPosition(), (CharSequence)("Service : " + serviceNode.getName().getValue() + " is considered as client message listener."));
            return false;
        }
        if (onMessageExists || onErrorExists || onCompleteExists) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"One or more resources(onMessage/onError/onComplete) is not implemented in client message listener.");
        }
        for (BLangResource resourceNode : resources) {
            if (ServiceDefinitionValidator.validateResourceSignature(resourceNode.getParameters(), dlog, resourceNode.pos)) continue;
            return ServiceDefinitionValidator.validateResourceSignature(resourceNode.getParameters(), dlog, resourceNode.pos);
        }
        return true;
    }

    private static boolean validateResourceSignature(List<BLangVariable> signatureParams, DiagnosticLog dlog, DiagnosticPos pos) {
        int nParams = signatureParams.size();
        if (nParams < 1) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"resource signature parameter count should be >= 1");
            return false;
        }
        if (!ServiceDefinitionValidator.isValidResourceParam(signatureParams.get(0), ENDPOINT_TYPE)) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"first parameter should be of type ballerina.grpc:Listener");
            return false;
        }
        return true;
    }

    private static boolean isValidResourceParam(BLangVariable param, String expectedType) {
        return expectedType.equals(param.type.toString());
    }
}

