/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.serviceendpoint;

import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.PrintStream;
import org.ballerinalang.bre.Context;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.grpc.GrpcServicesBuilder;
import org.ballerinalang.net.grpc.exception.GrpcServerException;
import org.ballerinalang.net.grpc.nativeimpl.AbstractGrpcNativeFunction;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="start", receiver=@Receiver(type=TypeKind.STRUCT, structType="Listener", structPackage="ballerina.grpc"), isPublic=true)
public class Start
extends AbstractGrpcNativeFunction {
    private static final PrintStream console = System.out;

    public void execute(Context context) {
        BStruct serviceEndpoint = (BStruct)context.getRefArgument(0);
        ServerBuilder serverBuilder = this.getServiceBuilder(serviceEndpoint);
        try {
            Server server = GrpcServicesBuilder.start(serverBuilder);
            serviceEndpoint.addNativeData("SERVER", (Object)server);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> GrpcServicesBuilder.stop(server)));
            console.println("ballerina: started gRPC server connector on port " + server.getPort());
            GrpcServicesBuilder.blockUntilShutdown(server);
        }
        catch (GrpcServerException e) {
            throw new BallerinaConnectorException(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new BallerinaConnectorException("gRPC server is interrupted.", (Throwable)e);
        }
        context.setReturnValues(new BValue[0]);
    }
}

