/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.proto.definition;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.EmptyProto;
import java.util.List;
import org.ballerinalang.net.grpc.exception.GrpcServerException;
import org.ballerinalang.net.grpc.proto.definition.Message;
import org.ballerinalang.net.grpc.proto.definition.MessageKind;

public class EmptyMessage
extends Message {
    private Descriptors.Descriptor descriptor;

    private EmptyMessage(Descriptors.Descriptor descriptor) {
        this.descriptor = descriptor;
        this.messageName = descriptor.getFullName();
    }

    public DescriptorProtos.DescriptorProto getDescriptorProto() {
        if (this.descriptor != null) {
            return this.descriptor.toProto();
        }
        return null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public MessageKind getMessageKind() {
        return MessageKind.EMPTY;
    }

    @Override
    public String getDependency() {
        return "google/protobuf/empty.proto";
    }

    public static class Builder {
        public Message build() throws GrpcServerException {
            Descriptors.Descriptor descriptor = this.getDescriptor();
            return new EmptyMessage(descriptor);
        }

        private Builder() {
        }

        public Descriptors.Descriptor getDescriptor() throws GrpcServerException {
            List descriptors = EmptyProto.getDescriptor().getMessageTypes();
            if (descriptors.size() == 0) {
                throw new GrpcServerException("Error while deriving message definition. Cannot find descriptor for empty message");
            }
            return (Descriptors.Descriptor)descriptors.get(0);
        }
    }
}

