/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.InputStream;
import java.util.Map;
import org.ballerinalang.net.grpc.Codec;
import org.ballerinalang.net.grpc.Decompressor;
import org.ballerinalang.net.grpc.DecompressorRegistry;
import org.ballerinalang.net.grpc.MessageDeframer;
import org.ballerinalang.net.grpc.StreamListener;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;
import org.wso2.transport.http.netty.contract.exceptions.ServerConnectorException;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class InboundMessage {
    private final HttpCarbonMessage httpCarbonMessage;

    InboundMessage(HttpCarbonMessage httpCarbonMessage) {
        this.httpCarbonMessage = httpCarbonMessage;
    }

    public boolean isEmpty() {
        return this.httpCarbonMessage.isEmpty();
    }

    public HttpHeaders getHeaders() {
        return this.httpCarbonMessage.getHeaders();
    }

    public String getHeader(String key) {
        return this.httpCarbonMessage.getHeader(key);
    }

    public Object getProperty(String key) {
        return this.httpCarbonMessage.getProperty(key);
    }

    public Map<String, Object> getProperties() {
        return this.httpCarbonMessage.getProperties();
    }

    public void setProperty(String key, Object value) {
        this.httpCarbonMessage.setProperty(key, value);
    }

    public String getPath() {
        return (String)this.httpCarbonMessage.getProperty("TO");
    }

    public int getStatus() {
        return this.httpCarbonMessage.getHttpStatusCode();
    }

    public String getHttpMethod() {
        return this.httpCarbonMessage.getHttpMethod();
    }

    HttpCarbonMessage getHttpCarbonMessage() {
        return this.httpCarbonMessage;
    }

    public boolean respond(HttpCarbonMessage carbonMessage) throws ServerConnectorException {
        HttpResponseFuture statusFuture = this.httpCarbonMessage.respond(carbonMessage);
        return statusFuture.getStatus().getCause() == null;
    }

    public Decompressor getMessageDecompressor() {
        String contentEncodingHeader = this.httpCarbonMessage.getHeader("grpc-encoding");
        if (contentEncodingHeader != null) {
            this.httpCarbonMessage.removeHeader(HttpHeaderNames.CONTENT_ENCODING.toString());
            Decompressor decompressor = DecompressorRegistry.getDefaultInstance().lookupDecompressor(contentEncodingHeader);
            if (decompressor != null) {
                return decompressor;
            }
        }
        return null;
    }

    public static abstract class InboundStateListener
    implements MessageDeframer.Listener {
        private MessageDeframer deframer;

        InboundStateListener(int maxMessageSize) {
            this.deframer = new MessageDeframer(this, Codec.Identity.NONE, maxMessageSize);
        }

        protected abstract StreamListener listener();

        @Override
        public void messagesAvailable(InputStream inputStream) {
            this.listener().messagesAvailable(inputStream);
        }

        final void closeDeframer(boolean stopDelivery) {
            if (stopDelivery) {
                this.deframer.close();
            } else {
                this.deframer.closeWhenComplete();
            }
        }

        final void deframe(HttpContent httpContent) {
            try {
                this.deframer.deframe(httpContent);
            }
            catch (Exception ex) {
                this.deframeFailed(ex);
            }
        }

        protected final void setDecompressor(Decompressor decompressor) {
            this.deframer.setDecompressor(decompressor);
        }
    }
}

