/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.builder.components;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.net.grpc.ServerConnectorPortBindingListener;
import org.ballerinalang.net.grpc.builder.components.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceFile {
    private boolean bidiStreaming;
    private boolean clientStreaming;
    private boolean unary;
    private String serviceName;
    private List<Method> unaryFunctions = new ArrayList<Method>();
    private Method streamingFunction = null;

    private ServiceFile(String serviceName) {
        this.serviceName = serviceName;
    }

    public static Builder newBuilder(String serviceName) {
        return new Builder(serviceName);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public List<Method> getunaryFunctions() {
        return Collections.unmodifiableList(this.unaryFunctions);
    }

    public Method getStreamingFunction() {
        return this.streamingFunction;
    }

    public boolean isBidiStreaming() {
        return this.bidiStreaming;
    }

    public boolean isClientStreaming() {
        return this.clientStreaming;
    }

    public boolean isUnary() {
        return this.unary;
    }

    public static class Builder {
        String serviceName;
        List<Method> methodList = new ArrayList<Method>();
        private static final Logger log = LoggerFactory.getLogger(ServerConnectorPortBindingListener.class);
        private static final PrintStream console = System.err;

        private Builder(String serviceName) {
            this.serviceName = serviceName;
        }

        public Builder addMethod(Method method) {
            this.methodList.add(method);
            return this;
        }

        public ServiceFile build() {
            ServiceFile serviceFile = new ServiceFile(this.serviceName);
            block5: for (Method method : this.methodList) {
                String message;
                switch (method.getMethodType()) {
                    case UNARY: 
                    case SERVER_STREAMING: {
                        if (!serviceFile.clientStreaming && !serviceFile.bidiStreaming) {
                            serviceFile.unaryFunctions.add(method);
                            serviceFile.unary = true;
                            continue block5;
                        }
                        message = this.serviceName + "/" + method.getMethodName() + " is not implemented. There should be only one method for client streaming or bidirectional streaming.";
                        log.error(message);
                        console.println(message);
                        continue block5;
                    }
                    case CLIENT_STREAMING: {
                        if (serviceFile.streamingFunction == null && !serviceFile.unary) {
                            serviceFile.streamingFunction = method;
                            serviceFile.clientStreaming = true;
                            continue block5;
                        }
                        message = this.serviceName + "/" + method.getMethodName() + " is not implemented. There should be only one method for client streaming.";
                        log.error(message);
                        console.println(message);
                        continue block5;
                    }
                    case BIDI_STREAMING: {
                        if (serviceFile.streamingFunction == null && !serviceFile.unary) {
                            serviceFile.streamingFunction = method;
                            serviceFile.bidiStreaming = true;
                            continue block5;
                        }
                        message = this.serviceName + "/" + method.getMethodName() + " is not implemented. There should be only one method for bidirectional streaming.";
                        log.error(message);
                        console.println(message);
                        continue block5;
                    }
                }
                message = this.serviceName + "/" + method.getMethodName() + " is not implemented. Method type is unknown or not supported.";
                log.error(message);
                console.println(message);
            }
            return serviceFile;
        }
    }
}

