/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.listener;

import com.google.protobuf.Descriptors;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.List;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.jvm.values.connector.Executor;
import org.ballerinalang.net.grpc.CallStreamObserver;
import org.ballerinalang.net.grpc.GrpcConstants;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.ServerCall;
import org.ballerinalang.net.grpc.ServiceResource;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.StreamObserver;
import org.ballerinalang.net.grpc.callback.StreamingCallableUnitCallBack;
import org.ballerinalang.net.grpc.callback.UnaryCallableUnitCallBack;

public abstract class ServerCallHandler {
    static final String TOO_MANY_REQUESTS = "Too many requests";
    static final String MISSING_REQUEST = "Half-closed without a request";
    private Descriptors.MethodDescriptor methodDescriptor;

    ServerCallHandler(Descriptors.MethodDescriptor methodDescriptor) {
        this.methodDescriptor = methodDescriptor;
    }

    public abstract Listener startCall(ServerCall var1);

    private ObjectValue getConnectionParameter(StreamObserver responseObserver) {
        ObjectValue clientEndpoint = BallerinaValues.createObjectValue((BPackage)GrpcConstants.PROTOCOL_GRPC_PKG_ID, (String)"Caller", (Object[])new Object[0]);
        clientEndpoint.set("instanceId", (Object)responseObserver.hashCode());
        clientEndpoint.addNativeData("RESPONSE_OBSERVER", (Object)responseObserver);
        clientEndpoint.addNativeData("RESPONSE_DEFINITION", (Object)this.methodDescriptor.getOutputType());
        return clientEndpoint;
    }

    private boolean isEmptyResponse() {
        return this.methodDescriptor != null && MessageUtils.isEmptyResponse(this.methodDescriptor.getOutputType());
    }

    void onErrorInvoke(ServiceResource resource, StreamObserver responseObserver, Message error) {
        List<BType> signatureParams = resource.getParamTypes();
        Object[] paramValues = new Object[signatureParams.size() * 2];
        paramValues[0] = this.getConnectionParameter(responseObserver);
        paramValues[1] = true;
        ErrorValue errorStruct = MessageUtils.getConnectorError(error.getError());
        paramValues[2] = errorStruct;
        paramValues[3] = true;
        ObjectValue headerStruct = null;
        if (resource.isHeaderRequired()) {
            headerStruct = MessageUtils.getHeaderObject();
            headerStruct.addNativeData("MessageHeaders", (Object)error.getHeaders());
        }
        if (headerStruct != null && signatureParams.size() == 3) {
            paramValues[4] = headerStruct;
            paramValues[5] = true;
        }
        StreamingCallableUnitCallBack callback = new StreamingCallableUnitCallBack(null);
        Executor.submit((Scheduler)resource.getScheduler(), (ObjectValue)resource.getService(), (String)resource.getFunctionName(), (CallableUnitCallback)callback, null, (Object[])paramValues);
    }

    void onMessageInvoke(ServiceResource resource, Message request, StreamObserver responseObserver) {
        UnaryCallableUnitCallBack callback = new UnaryCallableUnitCallBack(responseObserver, this.isEmptyResponse());
        Object[] requestParams = this.computeMessageParams(resource, request, responseObserver);
        Executor.submit((Scheduler)resource.getScheduler(), (ObjectValue)resource.getService(), (String)resource.getFunctionName(), (CallableUnitCallback)callback, null, (Object[])requestParams);
    }

    Object[] computeMessageParams(ServiceResource resource, Message request, StreamObserver responseObserver) {
        Object requestParam;
        List<BType> signatureParams = resource.getParamTypes();
        Object[] paramValues = new Object[signatureParams.size() * 2];
        paramValues[0] = this.getConnectionParameter(responseObserver);
        paramValues[1] = true;
        ObjectValue headerStruct = null;
        if (resource.isHeaderRequired()) {
            headerStruct = MessageUtils.getHeaderObject();
            headerStruct.addNativeData("MessageHeaders", (Object)request.getHeaders());
        }
        Object object = requestParam = request != null ? request.getbMessage() : null;
        if (requestParam != null) {
            paramValues[2] = requestParam;
            paramValues[3] = true;
        }
        if (headerStruct != null && signatureParams.size() == 3) {
            paramValues[4] = headerStruct;
            paramValues[5] = true;
        }
        return paramValues;
    }

    public static interface Listener {
        public void onMessage(Message var1);

        public void onHalfClose();

        public void onCancel();

        public void onComplete();
    }

    public static final class ServerCallStreamObserver
    implements CallStreamObserver {
        final ServerCall call;
        volatile boolean cancelled;
        private boolean sentHeaders;

        ServerCallStreamObserver(ServerCall call) {
            this.call = call;
        }

        @Override
        public void setMessageCompression(boolean enable) {
            this.call.setMessageCompression(enable);
        }

        public void setCompression(String compression) {
            this.call.setCompression(compression);
        }

        @Override
        public void onNext(Message response) {
            if (this.cancelled) {
                throw Status.Code.CANCELLED.toStatus().withDescription("call already cancelled").asRuntimeException();
            }
            if (!this.sentHeaders) {
                this.call.sendHeaders(response.getHeaders());
                this.sentHeaders = true;
            }
            this.call.sendMessage(response);
        }

        @Override
        public void onError(Message error) {
            if (!this.sentHeaders) {
                this.call.sendHeaders(error.getHeaders());
                this.sentHeaders = true;
            }
            this.call.close(Status.fromThrowable(error.getError()), (HttpHeaders)new DefaultHttpHeaders());
        }

        @Override
        public void onCompleted() {
            if (this.cancelled) {
                throw Status.Code.CANCELLED.toStatus().withDescription("call already cancelled").asRuntimeException();
            }
            this.call.close(Status.Code.OK.toStatus(), (HttpHeaders)new DefaultHttpHeaders());
        }

        @Override
        public boolean isReady() {
            return this.call.isReady();
        }

        public boolean isCancelled() {
            return this.call.isCancelled();
        }
    }
}

