/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.streamingclient;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.StreamObserver;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BallerinaFunction(orgName="ballerina", packageName="grpc", functionName="complete", receiver=@Receiver(type=TypeKind.OBJECT, structType="StreamingClient", structPackage="ballerina/grpc"), isPublic=true)
public class Complete {
    private static final Logger LOG = LoggerFactory.getLogger(Complete.class);

    public static Object complete(Strand strand, ObjectValue streamingConnection) {
        StreamObserver requestSender = (StreamObserver)streamingConnection.getNativeData("REQUEST_SENDER");
        if (requestSender == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while completing the message. endpoint does not exist")));
        }
        try {
            requestSender.onCompleted();
        }
        catch (Exception e) {
            LOG.error("Error while sending complete message to server.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
        return null;
    }
}

