/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.proto;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.net.grpc.config.ServiceConfiguration;
import org.ballerinalang.net.grpc.proto.ServiceProtoUtils;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class ServiceDefinitionValidator {
    public static final int COMPULSORY_PARAM_COUNT = 1;
    private static final String ENDPOINT_TYPE = "ballerina/grpc:Caller";

    public static boolean validate(ServiceNode serviceNode, DiagnosticLog dlog) {
        return ServiceDefinitionValidator.validateAnnotation(serviceNode, dlog) && ServiceDefinitionValidator.validateResource(serviceNode, dlog);
    }

    private static boolean validateAnnotation(ServiceNode serviceNode, DiagnosticLog dlog) {
        List annotations = serviceNode.getAnnotationAttachments();
        ArrayList<BLangRecordLiteral.BLangRecordKeyValueField> annVals = new ArrayList<BLangRecordLiteral.BLangRecordKeyValueField>();
        int count = 0;
        for (AnnotationAttachmentNode annotation : annotations) {
            if (!annotation.getAnnotationName().getValue().equals("ServiceConfig") || annotation.getExpression() == null) continue;
            for (RecordLiteralNode.RecordField field : ((BLangRecordLiteral)annotation.getExpression()).fields) {
                annVals.add((BLangRecordLiteral.BLangRecordKeyValueField)field);
            }
            ++count;
        }
        if (count > 1) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"There cannot be more than one service annotations");
            return false;
        }
        if (count == 1) {
            boolean isNameExists = false;
            boolean clientStreaming = false;
            for (BLangRecordLiteral.BLangRecordKeyValueField keyValue : annVals) {
                switch (((BLangSimpleVarRef)keyValue.key.expr).variableName.getValue()) {
                    case "name": {
                        isNameExists = true;
                        break;
                    }
                    case "clientStreaming": {
                        clientStreaming = true;
                        break;
                    }
                }
            }
            return isNameExists && clientStreaming;
        }
        return true;
    }

    private static boolean validateResource(ServiceNode serviceNode, DiagnosticLog dlog) {
        List resources = serviceNode.getResources();
        ServiceConfiguration serviceConfig = ServiceProtoUtils.getServiceConfiguration(serviceNode);
        if (serviceConfig.getRpcEndpoint() != null && serviceConfig.isClientStreaming()) {
            if (resources.size() != 4) {
                dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"There should be four resources defined in client/bidirectional streaming services");
                return false;
            }
            boolean onMessageExists = false;
            boolean onOpenExists = false;
            boolean onErrorExists = false;
            boolean onCompleteExists = false;
            for (BLangFunction resourceNode : resources) {
                switch (resourceNode.getName().getValue()) {
                    case "onOpen": {
                        onOpenExists = true;
                        break;
                    }
                    case "onMessage": {
                        onMessageExists = true;
                        break;
                    }
                    case "onError": {
                        onErrorExists = true;
                        break;
                    }
                    case "onComplete": {
                        onCompleteExists = true;
                        break;
                    }
                }
                if (ServiceDefinitionValidator.validateResourceSignature(resourceNode, dlog, resourceNode.pos)) continue;
                return false;
            }
            if (onMessageExists && onOpenExists && onErrorExists && onCompleteExists) {
                return true;
            }
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"One or more resources(onOpen/onMessage/onError/onComplete) is not implemented in client/bidirectional streaming service");
            return false;
        }
        for (BLangFunction resourceNode : resources) {
            if (ServiceDefinitionValidator.validateResourceSignature(resourceNode, dlog, resourceNode.pos)) continue;
            return false;
        }
        return true;
    }

    private static boolean validateResourceSignature(BLangFunction resourceNode, DiagnosticLog dlog, DiagnosticPos pos) {
        List signatureParams = resourceNode.getParameters();
        int nParams = signatureParams.size();
        if (nParams < 1) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"resource signature parameter count should be >= 1");
            return false;
        }
        if (!ServiceDefinitionValidator.isValidResourceParam((BLangSimpleVariable)signatureParams.get(0), ENDPOINT_TYPE)) {
            dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)pos, (CharSequence)"first parameter should be of type ballerina/grpc:Caller");
            return false;
        }
        return true;
    }

    private static boolean isValidResourceParam(BLangSimpleVariable param, String expectedType) {
        return expectedType.equals(param.type.toString());
    }
}

