/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.proto;

import com.google.protobuf.DescriptorProtos;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.BlockNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.ballerinalang.model.tree.statements.StatementNode;
import org.ballerinalang.model.types.FiniteType;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.net.grpc.config.ResourceConfiguration;
import org.ballerinalang.net.grpc.config.ServiceConfiguration;
import org.ballerinalang.net.grpc.exception.GrpcServerException;
import org.ballerinalang.net.grpc.proto.definition.EmptyMessage;
import org.ballerinalang.net.grpc.proto.definition.EnumField;
import org.ballerinalang.net.grpc.proto.definition.Field;
import org.ballerinalang.net.grpc.proto.definition.File;
import org.ballerinalang.net.grpc.proto.definition.Message;
import org.ballerinalang.net.grpc.proto.definition.MessageKind;
import org.ballerinalang.net.grpc.proto.definition.Method;
import org.ballerinalang.net.grpc.proto.definition.Service;
import org.ballerinalang.net.grpc.proto.definition.UserDefinedEnumMessage;
import org.ballerinalang.net.grpc.proto.definition.UserDefinedMessage;
import org.ballerinalang.net.grpc.proto.definition.WrapperMessage;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BNilType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;

public class ServiceProtoUtils {
    private static final String NO_PACKAGE_PATH = ".";
    private static final BNilType bNilType = new BNilType();

    private ServiceProtoUtils() {
    }

    static File generateProtoDefinition(ServiceNode serviceNode) throws GrpcServerException {
        String packageName = serviceNode.getPosition().getSource().getPackageName();
        File.Builder fileBuilder = !NO_PACKAGE_PATH.equals(packageName) ? File.newBuilder(serviceNode.getName() + ".proto").setSyntax("proto3").setPackage(serviceNode.getPosition().getSource().getPackageName()) : File.newBuilder(serviceNode.getName() + ".proto").setSyntax("proto3");
        ServiceConfiguration serviceConfig = ServiceProtoUtils.getServiceConfiguration(serviceNode);
        Service serviceDefinition = serviceConfig.getRpcEndpoint() != null && serviceConfig.isClientStreaming() ? ServiceProtoUtils.getStreamingServiceDefinition(serviceNode, serviceConfig, fileBuilder) : ServiceProtoUtils.getUnaryServiceDefinition(serviceNode, fileBuilder);
        fileBuilder.setService(serviceDefinition);
        return fileBuilder.build();
    }

    static ServiceConfiguration getServiceConfiguration(ServiceNode serviceNode) {
        String rpcEndpoint = null;
        BType requestType = null;
        BType responseType = null;
        boolean clientStreaming = false;
        boolean serverStreaming = false;
        for (AnnotationAttachmentNode annotationNode : serviceNode.getAnnotationAttachments()) {
            if (!"ServiceConfig".equals(annotationNode.getAnnotationName().getValue()) || !(annotationNode.getExpression() instanceof BLangRecordLiteral)) continue;
            ArrayList<BLangRecordLiteral.BLangRecordKeyValueField> attributes = new ArrayList<BLangRecordLiteral.BLangRecordKeyValueField>();
            for (RecordLiteralNode.RecordField attribute : ((BLangRecordLiteral)annotationNode.getExpression()).getFields()) {
                attributes.add((BLangRecordLiteral.BLangRecordKeyValueField)attribute);
            }
            for (BLangRecordLiteral.BLangRecordKeyValueField attributeNode : attributes) {
                String attributeName = attributeNode.getKey().toString();
                BLangExpression attributeValue = attributeNode.getValue();
                switch (attributeName) {
                    case "name": {
                        rpcEndpoint = attributeValue != null ? attributeValue.toString() : null;
                        break;
                    }
                    case "clientStreaming": {
                        clientStreaming = attributeValue != null && Boolean.parseBoolean(attributeValue.toString());
                        break;
                    }
                    case "serverStreaming": {
                        serverStreaming = attributeValue != null && Boolean.parseBoolean(attributeValue.toString());
                        break;
                    }
                    case "requestType": {
                        requestType = ServiceProtoUtils.getMessageBType(attributeValue);
                        break;
                    }
                    case "responseType": {
                        responseType = ServiceProtoUtils.getMessageBType(attributeValue);
                        break;
                    }
                }
            }
        }
        return new ServiceConfiguration(rpcEndpoint, requestType, responseType, clientStreaming, serverStreaming);
    }

    private static BType getMessageBType(BLangExpression attributeValue) {
        BType requestType = null;
        if (NodeKind.SIMPLE_VARIABLE_REF.equals((Object)attributeValue.getKind())) {
            requestType = ((BLangSimpleVarRef)attributeValue).symbol.getType();
        } else if (NodeKind.TYPEDESC_EXPRESSION.equals((Object)attributeValue.getKind())) {
            requestType = ((BLangTypedescExpr)attributeValue).resolvedType;
        }
        return requestType;
    }

    private static ResourceConfiguration getResourceConfiguration(FunctionNode resourceNode) {
        boolean streaming = false;
        BType requestType = null;
        BType responseType = null;
        for (AnnotationAttachmentNode annotationNode : resourceNode.getAnnotationAttachments()) {
            if (!"ResourceConfig".equals(annotationNode.getAnnotationName().getValue()) || !(annotationNode.getExpression() instanceof BLangRecordLiteral)) continue;
            ArrayList<BLangRecordLiteral.BLangRecordKeyValueField> attributes = new ArrayList<BLangRecordLiteral.BLangRecordKeyValueField>();
            for (RecordLiteralNode.RecordField attribute : ((BLangRecordLiteral)annotationNode.getExpression()).getFields()) {
                attributes.add((BLangRecordLiteral.BLangRecordKeyValueField)attribute);
            }
            for (BLangRecordLiteral.BLangRecordKeyValueField attributeNode : attributes) {
                String attributeName = attributeNode.getKey().toString();
                BLangExpression attributeValue = attributeNode.getValue();
                switch (attributeName) {
                    case "streaming": {
                        streaming = attributeValue != null && Boolean.parseBoolean(attributeValue.toString());
                        break;
                    }
                    case "requestType": {
                        requestType = ServiceProtoUtils.getMessageBType(attributeValue);
                        break;
                    }
                    case "responseType": {
                        responseType = ServiceProtoUtils.getMessageBType(attributeValue);
                        break;
                    }
                }
            }
        }
        return new ResourceConfiguration(streaming, requestType, responseType);
    }

    private static Service getUnaryServiceDefinition(ServiceNode serviceNode, File.Builder fileBuilder) throws GrpcServerException {
        Service.Builder serviceBuilder = Service.newBuilder(serviceNode.getName().getValue());
        for (FunctionNode resourceNode : serviceNode.getResources()) {
            Message responseMessage;
            ResourceConfiguration resourceConfiguration = ServiceProtoUtils.getResourceConfiguration(resourceNode);
            Message requestMessage = resourceConfiguration.getRequestType() != null ? ServiceProtoUtils.generateMessageDefinition(resourceConfiguration.getRequestType()) : ServiceProtoUtils.getRequestMessage(resourceNode);
            if (requestMessage == null) {
                throw new GrpcServerException("Error while deriving request message of the resource");
            }
            if (requestMessage.getMessageKind() == MessageKind.USER_DEFINED) {
                ServiceProtoUtils.updateFileBuilder(fileBuilder, requestMessage);
            }
            if (requestMessage.getDependency() != null && !fileBuilder.getRegisteredDependencies().contains(requestMessage.getDependency())) {
                fileBuilder.setDependency(requestMessage.getDependency());
            }
            if ((responseMessage = resourceConfiguration.getResponseType() != null ? ServiceProtoUtils.generateMessageDefinition(resourceConfiguration.getResponseType()) : ServiceProtoUtils.getResponseMessage(resourceNode)) == null) {
                throw new GrpcServerException("Connection send expression not found in resource body");
            }
            if (responseMessage.getMessageKind() == MessageKind.USER_DEFINED) {
                ServiceProtoUtils.updateFileBuilder(fileBuilder, responseMessage);
            }
            if (responseMessage.getDependency() != null && !fileBuilder.getRegisteredDependencies().contains(responseMessage.getDependency())) {
                fileBuilder.setDependency(responseMessage.getDependency());
            }
            boolean serverStreaming = ServiceProtoUtils.isServerStreaming(resourceNode);
            Method resourceMethod = Method.newBuilder(resourceNode.getName().getValue()).setClientStreaming(false).setServerStreaming(serverStreaming).setInputType(requestMessage.getCanonicalName()).setOutputType(responseMessage.getCanonicalName()).build();
            serviceBuilder.addMethod(resourceMethod);
        }
        return serviceBuilder.build();
    }

    private static boolean isNewMessageDefinition(File.Builder fileBuilder, Message message) {
        for (DescriptorProtos.DescriptorProto messageProto : fileBuilder.getRegisteredMessages()) {
            if (messageProto.getName() == null || !messageProto.getName().equals(message.getSimpleName())) continue;
            return false;
        }
        return true;
    }

    private static boolean isNewEnumDefinition(File.Builder fileBuilder, Message enumMsg) {
        for (DescriptorProtos.EnumDescriptorProto enumDescriptorProto : fileBuilder.getRegisteredEnums()) {
            if (enumDescriptorProto.getName() == null || !enumDescriptorProto.getName().equals(enumMsg.getSimpleName())) continue;
            return false;
        }
        return true;
    }

    private static Service getStreamingServiceDefinition(ServiceNode serviceNode, ServiceConfiguration serviceConfig, File.Builder fileBuilder) throws GrpcServerException {
        Service.Builder serviceBuilder = Service.newBuilder(serviceNode.getName().getValue());
        Message requestMessage = null;
        Message responseMessage = null;
        if (serviceConfig.getRequestType() != null) {
            requestMessage = ServiceProtoUtils.generateMessageDefinition(serviceConfig.getRequestType());
        }
        if (serviceConfig.getResponseType() != null) {
            responseMessage = ServiceProtoUtils.generateMessageDefinition(serviceConfig.getResponseType());
        }
        if (requestMessage == null || responseMessage == null) {
            for (FunctionNode resourceNode : serviceNode.getResources()) {
                Message respMsg;
                if ("onMessage".equals(resourceNode.getName().getValue())) {
                    requestMessage = requestMessage == null ? ServiceProtoUtils.getRequestMessage(resourceNode) : requestMessage;
                    Message message = respMsg = responseMessage == null ? ServiceProtoUtils.getResponseMessage(resourceNode) : responseMessage;
                    if (respMsg != null && !MessageKind.EMPTY.equals((Object)respMsg.getMessageKind())) {
                        responseMessage = respMsg;
                        break;
                    }
                }
                if (!"onComplete".equals(resourceNode.getName().getValue()) || (respMsg = responseMessage == null ? ServiceProtoUtils.getResponseMessage(resourceNode) : responseMessage) == null || MessageKind.EMPTY.equals((Object)respMsg.getMessageKind())) continue;
                responseMessage = respMsg;
            }
        }
        if (requestMessage == null) {
            requestMessage = ServiceProtoUtils.generateMessageDefinition((BType)bNilType);
        }
        if (responseMessage == null) {
            responseMessage = ServiceProtoUtils.generateMessageDefinition((BType)bNilType);
        }
        if (requestMessage.getMessageKind() == MessageKind.USER_DEFINED) {
            ServiceProtoUtils.updateFileBuilder(fileBuilder, requestMessage);
        }
        if (requestMessage.getDependency() != null && !fileBuilder.getRegisteredDependencies().contains(requestMessage.getDependency())) {
            fileBuilder.setDependency(requestMessage.getDependency());
        }
        if (responseMessage.getMessageKind() == MessageKind.USER_DEFINED) {
            ServiceProtoUtils.updateFileBuilder(fileBuilder, responseMessage);
        }
        if (responseMessage.getDependency() != null && !fileBuilder.getRegisteredDependencies().contains(responseMessage.getDependency())) {
            fileBuilder.setDependency(responseMessage.getDependency());
        }
        Method resourceMethod = Method.newBuilder(serviceConfig.getRpcEndpoint()).setClientStreaming(serviceConfig.isClientStreaming()).setServerStreaming(serviceConfig.isServerStreaming()).setInputType(requestMessage.getCanonicalName()).setOutputType(responseMessage.getCanonicalName()).build();
        serviceBuilder.addMethod(resourceMethod);
        return serviceBuilder.build();
    }

    private static void updateFileBuilder(File.Builder fileBuilder, Message message) {
        if (ServiceProtoUtils.isNewMessageDefinition(fileBuilder, message)) {
            fileBuilder.setMessage(message);
        }
        for (UserDefinedMessage msg : message.getNestedMessageList()) {
            if (!ServiceProtoUtils.isNewMessageDefinition(fileBuilder, msg)) continue;
            fileBuilder.setMessage(msg);
        }
        for (UserDefinedEnumMessage enumMessage : message.getNestedEnumList()) {
            if (!ServiceProtoUtils.isNewEnumDefinition(fileBuilder, enumMessage)) continue;
            fileBuilder.setEnum(enumMessage);
        }
    }

    private static boolean isServerStreaming(FunctionNode resourceNode) {
        boolean serverStreaming = false;
        for (AnnotationAttachmentNode annotationNode : resourceNode.getAnnotationAttachments()) {
            if (!"ResourceConfig".equals(annotationNode.getAnnotationName().getValue()) || !(annotationNode.getExpression() instanceof BLangRecordLiteral)) continue;
            ArrayList<BLangRecordLiteral.BLangRecordKeyValueField> attributes = new ArrayList<BLangRecordLiteral.BLangRecordKeyValueField>();
            for (RecordLiteralNode.RecordField attribute : ((BLangRecordLiteral)annotationNode.getExpression()).getFields()) {
                attributes.add((BLangRecordLiteral.BLangRecordKeyValueField)attribute);
            }
            for (BLangRecordLiteral.BLangRecordKeyValueField attributeNode : attributes) {
                String attributeValue;
                String attributeName = attributeNode.getKey().toString();
                String string = attributeValue = attributeNode.getValue() != null ? attributeNode.getValue().toString() : null;
                if (!"streaming".equals(attributeName)) continue;
                serverStreaming = Boolean.parseBoolean(attributeValue);
            }
        }
        return serverStreaming;
    }

    private static Message getResponseMessage(FunctionNode resourceNode) throws GrpcServerException {
        BLangFunctionBody body = resourceNode.getBody();
        BLangInvocation sendExpression = body != null && body.getKind() == NodeKind.BLOCK_FUNCTION_BODY ? ServiceProtoUtils.getInvocationExpression((BlockNode)((BLangBlockFunctionBody)body)) : null;
        Object responseType = sendExpression != null ? ServiceProtoUtils.getReturnType(sendExpression) : bNilType;
        return ServiceProtoUtils.generateMessageDefinition((BType)responseType);
    }

    private static Message getRequestMessage(FunctionNode resourceNode) throws GrpcServerException {
        if (resourceNode.getParameters().isEmpty() && resourceNode.getParameters().size() >= 4) {
            throw new GrpcServerException("Service resource definition should contain more than one and less than four params. but contains " + resourceNode.getParameters().size());
        }
        BType requestType = ServiceProtoUtils.getMessageParamType(resourceNode.getParameters());
        return ServiceProtoUtils.generateMessageDefinition(requestType);
    }

    private static BType getMessageParamType(List<?> variableNodes) throws GrpcServerException {
        BNilType requestType = null;
        for (Object variable : variableNodes) {
            if (variable instanceof BLangNode) {
                BType tempType = ((BLangNode)variable).type;
                if (tempType.getKind().equals((Object)TypeKind.ARRAY)) {
                    requestType = tempType;
                    break;
                }
                if (tempType.tsymbol == null) {
                    throw new GrpcServerException("Invalid message type. Message type doesn't have type symbol");
                }
                if ("ballerina/grpc:Caller".equals(tempType.tsymbol.toString()) || "ballerina/grpc:Headers".equals(tempType.tsymbol.toString())) continue;
                requestType = tempType;
                break;
            }
            throw new GrpcServerException("Request Message type is not supported, should be lang variable.");
        }
        if (requestType == null) {
            requestType = bNilType;
        }
        return requestType;
    }

    private static Message generateMessageDefinition(BType messageType) throws GrpcServerException {
        Message message = null;
        switch (messageType.getKind()) {
            case STRING: {
                message = WrapperMessage.newBuilder("StringValue").build();
                break;
            }
            case INT: {
                message = WrapperMessage.newBuilder("Int64Value").build();
                break;
            }
            case FLOAT: {
                message = WrapperMessage.newBuilder("FloatValue").build();
                break;
            }
            case BOOLEAN: {
                message = WrapperMessage.newBuilder("BoolValue").build();
                break;
            }
            case ARRAY: {
                message = WrapperMessage.newBuilder("BytesValue").build();
                break;
            }
            case OBJECT: 
            case RECORD: {
                if (!(messageType instanceof BStructureType)) break;
                BStructureType structType = (BStructureType)messageType;
                message = ServiceProtoUtils.getStructMessage(structType);
                break;
            }
            case NIL: {
                message = EmptyMessage.newBuilder().build();
                break;
            }
            default: {
                throw new GrpcServerException("Field type '" + messageType.toString() + "' currently not supported");
            }
        }
        return message;
    }

    private static Message getStructMessage(BStructureType messageType) throws GrpcServerException {
        UserDefinedMessage.Builder messageBuilder = UserDefinedMessage.newBuilder(messageType.tsymbol.name.value);
        int fieldIndex = 0;
        for (BField structField : messageType.fields) {
            String fieldName = structField.getName().getValue();
            BType fieldType = structField.getType();
            String fieldLabel = null;
            if (fieldType instanceof BStructureType) {
                BStructureType structType = (BStructureType)fieldType;
                messageBuilder.addMessageDefinition(ServiceProtoUtils.getStructMessage(structType));
            } else if (fieldType instanceof BArrayType) {
                BArrayType arrayType = (BArrayType)fieldType;
                BType elementType = arrayType.getElementType();
                if (elementType instanceof BStructureType) {
                    messageBuilder.addMessageDefinition(ServiceProtoUtils.getStructMessage((BStructureType)elementType));
                }
                if (!(fieldType = elementType).toString().equals("byte")) {
                    fieldLabel = "repeated";
                }
            } else if (fieldType instanceof FiniteType) {
                UserDefinedEnumMessage.Builder enumBuilder = UserDefinedEnumMessage.newBuilder(fieldType.tsymbol.name.value);
                BFiniteType finiteType = (BFiniteType)fieldType;
                int enumFieldIndex = 0;
                EnumField.Builder enumFieldBuilder = EnumField.newBuilder();
                for (BLangExpression bLangExpression : finiteType.getValueSpace()) {
                    String enumValue = String.valueOf(bLangExpression);
                    EnumField enumField = enumFieldBuilder.setIndex(enumFieldIndex++).setName(enumValue).build();
                    enumBuilder.addFieldDefinition(enumField);
                }
                messageBuilder.addMessageDefinition(enumBuilder.build());
            }
            Field messageField = Field.newBuilder(fieldName).setIndex(++fieldIndex).setLabel(fieldLabel).setType(fieldType).build();
            messageBuilder.addFieldDefinition(messageField);
        }
        return messageBuilder.build();
    }

    private static BLangInvocation getInvocationExpression(BlockNode body) {
        if (body == null) {
            return null;
        }
        for (StatementNode statementNode : body.getStatements()) {
            BLangInvocation invocation;
            BLangExpressionStmt expressionStmt;
            BLangExpression langExpression;
            BLangForeach langForeach;
            BLangWhile langWhile;
            Object invocExp;
            BLangExpression expression = null;
            if (statementNode instanceof BLangWhile && (invocExp = ServiceProtoUtils.getInvocationExpression((BlockNode)(langWhile = (BLangWhile)statementNode).getBody())) != null) {
                return invocExp;
            }
            if (statementNode instanceof BLangForeach && (invocExp = ServiceProtoUtils.getInvocationExpression((BlockNode)(langForeach = (BLangForeach)statementNode).getBody())) != null) {
                return invocExp;
            }
            if (statementNode instanceof BLangIf) {
                BLangIf langIf = (BLangIf)statementNode;
                invocExp = ServiceProtoUtils.getInvocationExpression((BlockNode)langIf.getBody());
                if (invocExp != null) {
                    return invocExp;
                }
                invocExp = ServiceProtoUtils.getInvocationExpression((BlockNode)((BLangBlockStmt)langIf.getElseStatement()));
                if (invocExp != null) {
                    return invocExp;
                }
            }
            if (statementNode instanceof BLangMatch) {
                BLangMatch langMatch = (BLangMatch)statementNode;
                invocExp = langMatch.patternClauses.iterator();
                while (invocExp.hasNext()) {
                    BLangMatch.BLangMatchBindingPatternClause patternClause = (BLangMatch.BLangMatchBindingPatternClause)invocExp.next();
                    BLangInvocation invocExp2 = ServiceProtoUtils.getInvocationExpression((BlockNode)patternClause.body);
                    if (invocExp2 == null) continue;
                    return invocExp2;
                }
            }
            if (statementNode instanceof BLangAssignment) {
                BLangAssignment assignment = (BLangAssignment)statementNode;
                expression = assignment.getExpression();
            }
            if (statementNode instanceof BLangSimpleVariableDef) {
                BLangSimpleVariableDef variableDef = (BLangSimpleVariableDef)statementNode;
                BLangSimpleVariable variable = variableDef.getVariable();
                expression = variable.getInitialExpression();
            }
            if (statementNode instanceof BLangExpressionStmt && (langExpression = (expressionStmt = (BLangExpressionStmt)statementNode).getExpression()) instanceof BLangCheckedExpr) {
                BLangCheckedExpr checkedExpr = (BLangCheckedExpr)langExpression;
                expression = checkedExpr.getExpression();
            }
            if (!(expression instanceof BLangInvocation) || !"send".equals((invocation = (BLangInvocation)expression).getName().getValue())) continue;
            return invocation;
        }
        return null;
    }

    private static BType getReturnType(BLangInvocation invocation) throws GrpcServerException {
        if (invocation.getArgumentExpressions() != null && invocation.getArgumentExpressions().size() > 2) {
            throw new GrpcServerException("Incorrect argument expressions defined in send function: " + invocation.toString());
        }
        return ServiceProtoUtils.getMessageParamType(invocation.getArgumentExpressions());
    }

    static void writeServiceFiles(Path targetDirPath, String filename, File protoFileDefinition) throws GrpcServerException {
        if (targetDirPath == null) {
            throw new GrpcServerException("Target file directory path is null");
        }
        try {
            if (!Files.exists(targetDirPath, new LinkOption[0])) {
                Files.createDirectories(targetDirPath, new FileAttribute[0]);
            }
            Path protoFilePath = Paths.get(targetDirPath.toString(), filename + ".proto");
            Files.write(protoFilePath, protoFileDefinition.getFileDefinition().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new GrpcServerException("Error while writing file descriptor to file.", e);
        }
    }
}

