/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.stubs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.types.AttachedFunction;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.connector.CallableUnitCallback;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.ServiceResource;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.StreamObserver;
import org.ballerinalang.net.grpc.callback.ClientCallableUnitCallBack;
import org.ballerinalang.net.grpc.exception.GrpcClientException;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStreamObserver
implements StreamObserver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStreamObserver.class);
    private Map<String, ServiceResource> resourceMap = new HashMap<String, ServiceResource>();

    public DefaultStreamObserver(BRuntime runtime, ObjectValue callbackService) throws GrpcClientException {
        if (callbackService == null) {
            throw new GrpcClientException("Error while building the connection. Listener Service does not exist");
        }
        for (AttachedFunction function : callbackService.getType().getAttachedFunctions()) {
            this.resourceMap.put(function.getName(), new ServiceResource(runtime, callbackService, function));
        }
    }

    @Override
    public void onNext(Message value) {
        Object requestParam;
        ServiceResource resource = this.resourceMap.get("onMessage");
        if (resource == null) {
            String message = "Error in listener service definition. onNext resource does not exists";
            LOG.error(message);
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription(message)));
        }
        List<BType> signatureParams = resource.getParamTypes();
        Object[] paramValues = new Object[signatureParams.size() * 2];
        ObjectValue headerObject = null;
        if (resource.isHeaderRequired()) {
            headerObject = MessageUtils.getHeaderObject();
            headerObject.addNativeData("MessageHeaders", (Object)value.getHeaders());
        }
        if ((requestParam = value.getbMessage()) != null) {
            paramValues[0] = requestParam;
            paramValues[1] = true;
        }
        if (headerObject != null && signatureParams.size() == 2) {
            paramValues[2] = headerObject;
            paramValues[3] = true;
        }
        ClientCallableUnitCallBack callback = new ClientCallableUnitCallBack();
        resource.getRuntime().invokeMethodAsync(resource.getService(), resource.getFunctionName(), (CallableUnitCallback)callback, null, paramValues);
    }

    @Override
    public void onError(Message error) {
        ServiceResource onError = this.resourceMap.get("onError");
        if (onError == null) {
            String message = "Error in listener service definition. onError resource does not exists";
            LOG.error(message);
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription(message)));
        }
        List<BType> signatureParams = onError.getParamTypes();
        Object[] paramValues = new Object[signatureParams.size() * 2];
        ObjectValue headerObject = null;
        if (onError.isHeaderRequired()) {
            headerObject = MessageUtils.getHeaderObject();
            headerObject.addNativeData("MessageHeaders", (Object)error.getHeaders());
        }
        ErrorValue errorStruct = MessageUtils.getConnectorError(error.getError());
        paramValues[0] = errorStruct;
        paramValues[1] = true;
        if (headerObject != null && signatureParams.size() == 2) {
            paramValues[2] = headerObject;
            paramValues[3] = true;
        }
        ClientCallableUnitCallBack callback = new ClientCallableUnitCallBack();
        onError.getRuntime().invokeMethodAsync(onError.getService(), onError.getFunctionName(), (CallableUnitCallback)callback, null, paramValues);
    }

    @Override
    public void onCompleted() {
        ServiceResource onCompleted = this.resourceMap.get("onComplete");
        if (onCompleted == null) {
            String message = "Error in listener service definition. onCompleted resource does not exists";
            LOG.error(message);
            throw MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription(message)));
        }
        List<BType> signatureParams = onCompleted.getParamTypes();
        Object[] paramValues = new Object[signatureParams.size() * 2];
        ClientCallableUnitCallBack callback = new ClientCallableUnitCallBack();
        onCompleted.getRuntime().invokeMethodAsync(onCompleted.getService(), onCompleted.getFunctionName(), (CallableUnitCallback)callback, null, paramValues);
    }
}

