/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.ballerinalang.net.grpc.Compressor;
import org.ballerinalang.net.grpc.Decompressor;

public interface Codec
extends Compressor,
Decompressor {
    public static final String GZIP = "gzip";
    public static final String IDENTITY = "identity";

    public static final class Identity
    implements Codec {
        public static final Codec NONE = new Identity();

        @Override
        public InputStream decompress(InputStream is) {
            return is;
        }

        @Override
        public String getMessageEncoding() {
            return Codec.IDENTITY;
        }

        @Override
        public OutputStream compress(OutputStream os) {
            return os;
        }

        private Identity() {
        }
    }

    public static final class Gzip
    implements Codec {
        @Override
        public String getMessageEncoding() {
            return Codec.GZIP;
        }

        @Override
        public OutputStream compress(OutputStream os) throws IOException {
            return new GZIPOutputStream(os);
        }

        @Override
        public InputStream decompress(InputStream is) throws IOException {
            return new GZIPInputStream(is);
        }
    }
}

