/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.ballerinalang.net.grpc.InboundMessage;
import org.ballerinalang.net.grpc.MessageFramer;
import org.ballerinalang.net.grpc.Status;
import org.wso2.transport.http.netty.message.HttpCarbonMessage;

public class OutboundMessage {
    private static final int NULL_STATUS_CODE = -1;
    private final HttpCarbonMessage responseMessage;
    private int statusCode = -1;
    private boolean outboundClosed;
    private final ThreadLocal<MessageFramer> framer;

    public OutboundMessage(HttpCarbonMessage responseMessage) {
        this.responseMessage = responseMessage;
        this.framer = ThreadLocal.withInitial(() -> new MessageFramer(responseMessage));
    }

    OutboundMessage(InboundMessage inboundMessage) {
        this(inboundMessage.getHttpCarbonMessage().cloneCarbonMessageWithOutData());
    }

    public boolean isEmpty() {
        return this.responseMessage.isEmpty();
    }

    public HttpHeaders getHeaders() {
        return this.responseMessage.getHeaders();
    }

    public String getHeader(String key) {
        return this.responseMessage.getHeader(key);
    }

    public OutboundMessage setHeader(String key, String value) {
        this.responseMessage.setHeader(key, value);
        return this;
    }

    public void setHeaders(Map<String, String> headerMap) {
        headerMap.forEach((arg_0, arg_1) -> ((HttpCarbonMessage)this.responseMessage).setHeader(arg_0, arg_1));
    }

    public Object getProperty(String key) {
        return this.responseMessage.getProperty(key);
    }

    public Map<String, Object> getProperties() {
        return this.responseMessage.getProperties();
    }

    public void setProperty(String key, Object value) {
        this.responseMessage.setProperty(key, value);
    }

    public void removeHeader(String key) {
        this.responseMessage.removeHeader(key);
    }

    HttpCarbonMessage getResponseMessage() {
        return this.responseMessage;
    }

    public OutboundMessage setStatus(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void sendMessage(InputStream entity) {
        if (entity != null) {
            this.framer().writePayload(entity);
            this.framer().flush();
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(0);
            this.responseMessage.addHttpContent((HttpContent)new DefaultLastHttpContent(Unpooled.wrappedBuffer((ByteBuffer)byteBuffer)));
        }
    }

    public void complete(Status status, HttpHeaders trailers) {
        this.framer().flush();
        this.framer().dispose();
        this.addStatusToTrailers(status, trailers);
        DefaultLastHttpContent lastHttpContent = new DefaultLastHttpContent();
        lastHttpContent.trailingHeaders().set(trailers);
        this.responseMessage.addHttpContent((HttpContent)lastHttpContent);
    }

    private void addStatusToTrailers(Status status, HttpHeaders trailers) {
        trailers.remove("grpc-status");
        trailers.remove("grpc-message");
        byte[] bytes = Status.CODE_MARSHALLER.toAsciiString(status);
        trailers.add("grpc-status", (Object)new String(bytes, StandardCharsets.US_ASCII));
        if (status.getDescription() != null) {
            trailers.add("grpc-message", (Object)new String(Status.MESSAGE_MARSHALLER.toAsciiString(status.getDescription()), StandardCharsets.US_ASCII));
        }
    }

    final void halfClose() {
        if (!this.outboundClosed) {
            this.outboundClosed = true;
            this.framer().close();
        }
    }

    final MessageFramer framer() {
        return this.framer.get();
    }

    public boolean isReady() {
        return !this.framer().isClosed();
    }

    public final void setMessageCompression(boolean enable) {
        this.framer().setMessageCompression(enable);
    }

    public final void flush() {
        if (!this.framer().isClosed()) {
            this.framer().flush();
        }
    }

    public String getHttpVersion() {
        return this.responseMessage.getHttpVersion();
    }

    public void setHttpVersion(String httpVersion) {
        this.responseMessage.setHttpVersion(httpVersion);
    }

    void setHttpMethod() {
        this.responseMessage.setHttpMethod("POST");
    }
}

