/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import org.ballerinalang.jvm.observability.ObserveUtils;
import org.ballerinalang.jvm.observability.ObserverContext;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.net.grpc.ClientConnectorListener;
import org.ballerinalang.net.grpc.Codec;
import org.ballerinalang.net.grpc.Compressor;
import org.ballerinalang.net.grpc.CompressorRegistry;
import org.ballerinalang.net.grpc.DataContext;
import org.ballerinalang.net.grpc.DecompressorRegistry;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.ObservableClientConnectorListener;
import org.ballerinalang.net.grpc.OutboundMessage;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.StreamListener;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.ballerinalang.net.grpc.stubs.AbstractStub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpClientConnector;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.HttpResponseFuture;

public final class ClientCall {
    private static final Logger log = LoggerFactory.getLogger(ClientCall.class);
    private final MethodDescriptor method;
    private final boolean unaryRequest;
    private HttpClientConnector connector;
    private DataContext context;
    private final OutboundMessage outboundMessage;
    private ClientConnectorListener connectorListener;
    private boolean cancelCalled;
    private boolean halfCloseCalled;
    private DecompressorRegistry decompressorRegistry = DecompressorRegistry.getDefaultInstance();
    private CompressorRegistry compressorRegistry = CompressorRegistry.getDefaultInstance();

    public ClientCall(HttpClientConnector connector, OutboundMessage outboundMessage, MethodDescriptor method, DataContext context) {
        this.method = method;
        this.unaryRequest = method.getType() == MethodDescriptor.MethodType.UNARY || method.getType() == MethodDescriptor.MethodType.SERVER_STREAMING;
        this.connector = connector;
        this.context = context;
        this.outboundMessage = outboundMessage;
    }

    private void prepareHeaders(Compressor compressor) {
        Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Strand)this.context.getStrand());
        this.outboundMessage.removeHeader("grpc-encoding");
        if (compressor != Codec.Identity.NONE) {
            this.outboundMessage.setHeader("grpc-encoding", compressor.getMessageEncoding());
        }
        String advertisedEncodings = String.join((CharSequence)",", this.decompressorRegistry.getAdvertisedMessageEncodings());
        this.outboundMessage.setHeader("grpc-accept-encoding", advertisedEncodings);
        this.outboundMessage.getHeaders().entries().forEach(x -> observerContext.ifPresent(ctx -> ctx.addTag((String)x.getKey(), (String)x.getValue())));
        this.outboundMessage.setProperty("TO", "/" + this.method.getFullMethodName());
        this.outboundMessage.setHttpMethod();
        this.outboundMessage.setHttpVersion("2.0");
        this.outboundMessage.setHeader("content-type", "application/grpc");
        this.outboundMessage.setHeader("te", "trailers");
    }

    public void checkAndObserveHttpRequest() {
        Optional observerContext = ObserveUtils.getObserverContextOfCurrentFrame((Strand)this.context.getStrand());
        observerContext.ifPresent(ctx -> {
            this.injectHeaders(this.outboundMessage, ObserveUtils.getContextProperties((ObserverContext)ctx));
            ctx.addTag("http.method", "POST");
            ctx.addTag("http.url", String.valueOf(this.outboundMessage.getProperty("TO")));
            ctx.addTag("peer.address", this.outboundMessage.getProperty("host") + ":" + this.outboundMessage.getProperty("port"));
            ctx.addTag("te", "trailers");
            ctx.addTag("content-type", "application/grpc");
            ctx.addTag("HTTP_VERSION", "2.0");
            ctx.addTag("http.status_code", Integer.toString(0));
        });
    }

    private void injectHeaders(OutboundMessage msg, Map<String, String> headers) {
        if (headers != null) {
            headers.forEach((key, value) -> msg.setHeader((String)key, String.valueOf(value)));
        }
    }

    public void start(AbstractStub.Listener observer) {
        Compressor compressor;
        if (this.connectorListener != null) {
            throw new IllegalStateException("Client connection already set up.");
        }
        if (this.cancelCalled) {
            throw new IllegalStateException("Client call was cancelled.");
        }
        String compressorName = this.outboundMessage.getHeader("grpc-encoding");
        if (compressorName != null) {
            compressor = this.compressorRegistry.lookupCompressor(compressorName);
            if (compressor == null) {
                this.closeObserver(observer, Status.Code.INTERNAL.toStatus().withDescription(String.format("Unable to find compressor by name %s", compressorName)), (HttpHeaders)new DefaultHttpHeaders());
                return;
            }
        } else {
            compressor = Codec.Identity.NONE;
        }
        this.prepareHeaders(compressor);
        ClientStreamListener clientStreamListener = new ClientStreamListener(observer);
        this.connectorListener = ObserveUtils.isObservabilityEnabled() ? new ObservableClientConnectorListener(clientStreamListener, this.context) : new ClientConnectorListener(clientStreamListener);
        this.outboundMessage.framer().setCompressor(compressor);
        this.connectorListener.setDecompressorRegistry(this.decompressorRegistry);
        HttpResponseFuture responseFuture = this.connector.send(this.outboundMessage.getResponseMessage());
        responseFuture.setHttpConnectorListener((HttpConnectorListener)this.connectorListener);
    }

    public void cancel(String message, Throwable cause) {
        if (message == null && cause == null) {
            cause = new CancellationException("Cancelled without a message or cause");
            log.error("Cancelling without a message or cause is suboptimal", cause);
        }
        if (this.cancelCalled) {
            return;
        }
        this.cancelCalled = true;
        if (this.outboundMessage != null) {
            Status status = Status.Code.CANCELLED.toStatus();
            if (cause instanceof StatusRuntimeException) {
                status = ((StatusRuntimeException)cause).getStatus();
            } else {
                status = message != null ? status.withDescription(message) : status.withDescription("Call cancelled without message");
                if (cause != null) {
                    status = status.withCause(cause);
                }
            }
            this.outboundMessage.complete(status, (HttpHeaders)new DefaultHttpHeaders());
        }
    }

    public void halfClose() {
        if (this.outboundMessage == null) {
            throw new IllegalStateException("Client call did not start properly.");
        }
        if (this.cancelCalled) {
            throw new IllegalStateException("Client call was called.");
        }
        if (this.halfCloseCalled) {
            throw new IllegalStateException("Client call was already closed.");
        }
        this.halfCloseCalled = true;
        this.outboundMessage.halfClose();
    }

    public void sendMessage(Message message) {
        if (this.connectorListener == null) {
            throw Status.Code.INTERNAL.toStatus().withDescription("Connector listener didn't initialize properly.").asRuntimeException();
        }
        if (this.cancelCalled) {
            throw Status.Code.INTERNAL.toStatus().withDescription("Client call was already cancelled.").asRuntimeException();
        }
        if (this.halfCloseCalled) {
            throw Status.Code.INTERNAL.toStatus().withDescription("Client call was already closed.").asRuntimeException();
        }
        try {
            InputStream resp = this.method.streamRequest(message);
            this.outboundMessage.sendMessage(resp);
        }
        catch (StatusRuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Status.Code.CANCELLED.toStatus().withCause(ex).withDescription("Failed to send the message").asRuntimeException();
        }
        if (!this.unaryRequest) {
            this.outboundMessage.flush();
        }
    }

    public void setMessageCompression(boolean enabled) {
        if (this.outboundMessage == null) {
            throw Status.Code.INTERNAL.toStatus().withDescription("Client call did not initiate properly.").asRuntimeException();
        }
        this.outboundMessage.setMessageCompression(enabled);
    }

    private void closeObserver(AbstractStub.Listener observer, Status status, HttpHeaders trailers) {
        observer.onClose(status, trailers);
    }

    public boolean isReady() {
        return this.outboundMessage.isReady();
    }

    public class ClientStreamListener
    implements StreamListener {
        private final AbstractStub.Listener observer;
        private boolean closed;
        private HttpHeaders responseHeaders;

        ClientStreamListener(AbstractStub.Listener observer) {
            this.observer = observer;
        }

        public void headersRead(HttpHeaders headers) {
            try {
                if (this.closed) {
                    return;
                }
                this.responseHeaders = headers;
                this.observer.onHeaders(headers);
            }
            catch (Exception ex) {
                Status status = Status.Code.CANCELLED.toStatus().withCause(ex).withDescription("Failed to read headers");
                this.close(status, (HttpHeaders)new DefaultHttpHeaders());
            }
        }

        @Override
        public void messagesAvailable(InputStream message) {
            if (this.closed) {
                MessageUtils.closeQuietly(message);
                return;
            }
            try {
                Message responseMessage = ClientCall.this.method.parseResponse(message);
                responseMessage.setHeaders(this.responseHeaders);
                this.observer.onMessage(responseMessage);
                message.close();
            }
            catch (Exception ex) {
                MessageUtils.closeQuietly(message);
                Status status = Status.Code.CANCELLED.toStatus().withCause(ex).withDescription("Failed to read message.");
                this.close(status, (HttpHeaders)new DefaultHttpHeaders());
            }
        }

        private void close(Status status, HttpHeaders trailers) {
            this.closed = true;
            ClientCall.this.closeObserver(this.observer, status, trailers);
        }

        public void closed(Status status, HttpHeaders trailers) {
            if (this.closed) {
                return;
            }
            this.close(status, trailers);
        }
    }
}

