/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.nativeimpl.serviceendpoint;

import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.net.grpc.GrpcUtil;
import org.ballerinalang.net.grpc.MessageUtils;
import org.ballerinalang.net.grpc.ServerConnectorListener;
import org.ballerinalang.net.grpc.ServerConnectorPortBindingListener;
import org.ballerinalang.net.grpc.ServicesBuilderUtils;
import org.ballerinalang.net.grpc.ServicesRegistry;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.exception.GrpcServerException;
import org.ballerinalang.net.grpc.exception.StatusRuntimeException;
import org.ballerinalang.net.grpc.nativeimpl.AbstractGrpcNativeFunction;
import org.ballerinalang.net.http.HttpConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.transport.http.netty.contract.HttpConnectorListener;
import org.wso2.transport.http.netty.contract.PortBindingEventListener;
import org.wso2.transport.http.netty.contract.ServerConnector;
import org.wso2.transport.http.netty.contract.ServerConnectorFuture;
import org.wso2.transport.http.netty.contract.config.ListenerConfiguration;

public class FunctionUtils
extends AbstractGrpcNativeFunction {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionUtils.class);

    public static Object externInitEndpoint(ObjectValue listenerObject) {
        MapValue serviceEndpointConfig = listenerObject.getMapValue("config");
        long port = listenerObject.getIntValue("port");
        try {
            ListenerConfiguration configuration = GrpcUtil.getListenerConfig(port, serviceEndpointConfig);
            ServerConnector httpServerConnector = HttpConnectionManager.getInstance().createHttpServerConnector(configuration);
            ServicesRegistry.Builder servicesRegistryBuilder = new ServicesRegistry.Builder();
            listenerObject.addNativeData("SERVER_CONNECTOR", (Object)httpServerConnector);
            listenerObject.addNativeData("SERVICE_REGISTRY_BUILDER", (Object)servicesRegistryBuilder);
            return null;
        }
        catch (ErrorValue ex) {
            return ex;
        }
        catch (Exception e) {
            LOG.error("Error while initializing service listener.", (Throwable)e);
            return MessageUtils.getConnectorError(e);
        }
    }

    public static Object externRegister(ObjectValue listenerObject, ObjectValue service, Object annotationData) {
        ServicesRegistry.Builder servicesRegistryBuilder = FunctionUtils.getServiceRegistryBuilder(listenerObject);
        try {
            if (servicesRegistryBuilder == null) {
                return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error when initializing service register builder.")));
            }
            servicesRegistryBuilder.addService(ServicesBuilderUtils.getServiceDefinition(BRuntime.getCurrentRuntime(), service, service.getType().getAnnotation("ballerina/grpc:ServiceDescriptor")));
            return null;
        }
        catch (GrpcServerException e) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error when initializing service register builder. " + e.getLocalizedMessage())));
        }
    }

    private static Object startServerConnector(ObjectValue listener, ServicesRegistry servicesRegistry) {
        ServerConnector serverConnector = FunctionUtils.getServerConnector(listener);
        ServerConnectorFuture serverConnectorFuture = serverConnector.start();
        serverConnectorFuture.setHttpConnectorListener((HttpConnectorListener)new ServerConnectorListener(servicesRegistry));
        serverConnectorFuture.setPortBindingEventListener((PortBindingEventListener)new ServerConnectorPortBindingListener());
        try {
            serverConnectorFuture.sync();
        }
        catch (Exception ex) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Failed to start server connector '" + serverConnector.getConnectorID() + "'. " + ex.getMessage())));
        }
        listener.addNativeData("CONNECTOR_STARTED", (Object)true);
        return null;
    }

    public static Object externStart(ObjectValue listener) {
        ServicesRegistry.Builder servicesRegistryBuilder = FunctionUtils.getServiceRegistryBuilder(listener);
        if (!FunctionUtils.isConnectorStarted(listener)) {
            return FunctionUtils.startServerConnector(listener, servicesRegistryBuilder.build());
        }
        return null;
    }

    public static Object externStop(ObjectValue serverEndpoint) {
        FunctionUtils.getServerConnector(serverEndpoint).stop();
        serverEndpoint.addNativeData("CONNECTOR_STARTED", (Object)false);
        return null;
    }
}

