/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;

public class CompositeContent {
    private int readableBytes;
    private final Queue<ByteBuf> buffers = new ArrayDeque<ByteBuf>();

    public final int readInt() {
        this.checkReadable(4);
        int b1 = this.readUnsignedByte();
        int b2 = this.readUnsignedByte();
        int b3 = this.readUnsignedByte();
        int b4 = this.readUnsignedByte();
        return b1 << 24 | b2 << 16 | b3 << 8 | b4;
    }

    private void checkReadable(int length) {
        if (this.readableBytes() < length) {
            throw new IndexOutOfBoundsException();
        }
    }

    public void addBuffer(ByteBuf buffer) {
        this.buffers.add(buffer);
        this.readableBytes += buffer.readableBytes();
    }

    public int readableBytes() {
        return this.readableBytes;
    }

    public int readUnsignedByte() {
        ReadOperation op = new ReadOperation(){

            @Override
            int readInternal(ByteBuf buffer, int length) {
                return buffer.readUnsignedByte();
            }
        };
        this.execute(op, 1);
        return op.value;
    }

    public void readBytes(final byte[] dest, final int destOffset, int length) {
        this.execute(new ReadOperation(){
            int currentOffset;
            {
                this.currentOffset = destOffset;
            }

            @Override
            public int readInternal(ByteBuf buffer, int length) {
                buffer.readBytes(dest, this.currentOffset, length);
                this.currentOffset += length;
                return 0;
            }
        }, length);
    }

    public ByteBuf readBuffer(int length) {
        ByteBuf buffer = this.buffers.peek();
        if (buffer == null) {
            this.readableBytes = 0;
            throw new RuntimeException("Error while reading inbound data from buffer. The buffer queue is empty");
        }
        if (buffer.readableBytes() > length) {
            this.readableBytes -= length;
            return buffer.readBytes(length);
        }
        this.readableBytes -= buffer.readableBytes();
        return this.buffers.poll();
    }

    public void close() {
        while (!this.buffers.isEmpty()) {
            ByteBuf byteBuf = this.buffers.remove();
            if (byteBuf.refCnt() == 0) continue;
            byteBuf.release();
        }
    }

    private void execute(ReadOperation op, int length) {
        this.checkReadable(length);
        if (!this.buffers.isEmpty()) {
            this.advanceBufferIfNecessary();
        }
        while (length > 0 && !this.buffers.isEmpty()) {
            ByteBuf buffer = this.buffers.peek();
            int lengthToCopy = Math.min(length, buffer.readableBytes());
            op.read(buffer, lengthToCopy);
            if (op.isError()) {
                return;
            }
            length -= lengthToCopy;
            this.readableBytes -= lengthToCopy;
            this.advanceBufferIfNecessary();
        }
        if (length > 0) {
            throw new AssertionError((Object)"Failed executing read operation");
        }
    }

    private void advanceBufferIfNecessary() {
        ByteBuf buffer = this.buffers.peek();
        if (buffer != null && buffer.readableBytes() == 0 && buffer.refCnt() != 0) {
            this.buffers.remove().release();
        }
    }

    private static abstract class ReadOperation {
        int value;
        IOException ex;

        private ReadOperation() {
        }

        final void read(ByteBuf buffer, int length) {
            try {
                this.value = this.readInternal(buffer, length);
            }
            catch (IOException e) {
                this.ex = e;
            }
        }

        final boolean isError() {
            return this.ex != null;
        }

        abstract int readInternal(ByteBuf var1, int var2) throws IOException;
    }
}

