/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.grpc.stubs;

import io.netty.handler.codec.http.HttpHeaders;
import org.ballerinalang.net.grpc.CallStreamObserver;
import org.ballerinalang.net.grpc.ClientCall;
import org.ballerinalang.net.grpc.DataContext;
import org.ballerinalang.net.grpc.Message;
import org.ballerinalang.net.grpc.MethodDescriptor;
import org.ballerinalang.net.grpc.Status;
import org.ballerinalang.net.grpc.StreamObserver;
import org.ballerinalang.net.grpc.stubs.AbstractStub;
import org.wso2.transport.http.netty.contract.HttpClientConnector;

public class NonBlockingStub
extends AbstractStub {
    public NonBlockingStub(HttpClientConnector clientConnector, String urlString) {
        super(clientConnector, urlString);
    }

    public void executeServerStreaming(Message request, StreamObserver responseObserver, MethodDescriptor methodDescriptor, DataContext context) throws Exception {
        ClientCall call = new ClientCall(this.getConnector(), this.createOutboundRequest(request.getHeaders()), methodDescriptor, context);
        call.start(new NonblockingCallListener(responseObserver, true));
        try {
            call.sendMessage(request);
            call.halfClose();
        }
        catch (Exception e) {
            NonBlockingStub.cancelThrow(call, e);
        }
    }

    public StreamObserver executeClientStreaming(HttpHeaders requestHeaders, StreamObserver responseObserver, MethodDescriptor methodDescriptor, DataContext context) {
        ClientCall call = new ClientCall(this.getConnector(), this.createOutboundRequest(requestHeaders), methodDescriptor, context);
        ClientCallStreamObserver streamObserver = new ClientCallStreamObserver(call);
        call.start(new NonblockingCallListener(responseObserver, false));
        return streamObserver;
    }

    public void executeUnary(Message request, StreamObserver responseObserver, MethodDescriptor methodDescriptor, DataContext context) throws Exception {
        ClientCall call = new ClientCall(this.getConnector(), this.createOutboundRequest(request.getHeaders()), methodDescriptor, context);
        call.start(new NonblockingCallListener(responseObserver, false));
        try {
            call.sendMessage(request);
            call.halfClose();
        }
        catch (Exception e) {
            NonBlockingStub.cancelThrow(call, e);
        }
    }

    public StreamObserver executeBidiStreaming(HttpHeaders requestHeaders, StreamObserver responseObserver, MethodDescriptor methodDescriptor, DataContext context) {
        ClientCall call = new ClientCall(this.getConnector(), this.createOutboundRequest(requestHeaders), methodDescriptor, context);
        ClientCallStreamObserver streamObserver = new ClientCallStreamObserver(call);
        call.start(new NonblockingCallListener(responseObserver, true));
        return streamObserver;
    }

    private static final class ClientCallStreamObserver
    implements CallStreamObserver {
        private final ClientCall call;

        ClientCallStreamObserver(ClientCall call) {
            this.call = call;
        }

        @Override
        public void onNext(Message value) {
            this.call.sendMessage(value);
        }

        @Override
        public void onError(Message error) {
            this.call.cancel("Cancelled by client with StreamObserver.onError()", error.getError());
        }

        @Override
        public void onCompleted() {
            this.call.halfClose();
        }

        @Override
        public boolean isReady() {
            return this.call.isReady();
        }

        @Override
        public void setMessageCompression(boolean enable) {
            this.call.setMessageCompression(enable);
        }
    }

    private static final class NonblockingCallListener
    implements AbstractStub.Listener {
        private final StreamObserver observer;
        private final boolean streamingResponse;
        private boolean firstResponseReceived;

        NonblockingCallListener(StreamObserver observer, boolean streamingResponse) {
            this.observer = observer;
            this.streamingResponse = streamingResponse;
        }

        @Override
        public void onHeaders(HttpHeaders headers) {
        }

        @Override
        public void onMessage(Message message) {
            if (this.firstResponseReceived && !this.streamingResponse) {
                throw Status.Code.INTERNAL.toStatus().withDescription("More than one responses received for unary or client-streaming call").asRuntimeException();
            }
            this.firstResponseReceived = true;
            this.observer.onNext(message);
        }

        @Override
        public void onClose(Status status, HttpHeaders trailers) {
            if (status.isOk()) {
                this.observer.onCompleted();
            } else {
                this.observer.onError(new Message(status.asRuntimeException()));
            }
        }
    }
}

