/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.DataChannel;
import org.ballerinalang.stdlib.io.channels.base.Representation;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataChannelUtils {
    private static final Logger log = LoggerFactory.getLogger(DataChannelUtils.class);

    private DataChannelUtils() {
    }

    private static ByteOrder getByteOrder(String byteOrder) {
        switch (byteOrder) {
            case "BE": {
                return ByteOrder.BIG_ENDIAN;
            }
            case "LE": {
                return ByteOrder.LITTLE_ENDIAN;
            }
        }
        return ByteOrder.nativeOrder();
    }

    public static void initReadableDataChannel(ObjectValue dataChannelObj, ObjectValue byteChannelObj, Object order) {
        try {
            ByteOrder byteOrder = DataChannelUtils.getByteOrder((String)order);
            Channel channel = (Channel)byteChannelObj.getNativeData("byteChannel");
            DataChannel dataChannel = new DataChannel(channel, byteOrder);
            dataChannelObj.addNativeData("data_channel", (Object)dataChannel);
        }
        catch (Exception e) {
            String message = "error while creating data channel: " + e.getMessage();
            log.error(message, (Throwable)e);
            throw IOUtils.createError(message);
        }
    }

    public static Object readInt16(ObjectValue dataChannelObj) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            return channel.readLong(Representation.BIT_16).getValue();
        }
        catch (IOException e) {
            log.error("error occurred while reading Int16", (Throwable)e);
            return IOUtils.createError(e);
        }
    }

    public static Object readInt32(ObjectValue dataChannelObj) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            return channel.readLong(Representation.BIT_32).getValue();
        }
        catch (IOException e) {
            log.error("error occurred while reading Int32", (Throwable)e);
            return IOUtils.createError(e);
        }
    }

    public static Object readInt64(ObjectValue dataChannelObj) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            return channel.readLong(Representation.BIT_64).getValue();
        }
        catch (IOException e) {
            log.error("error occurred while reading Int64", (Throwable)e);
            return IOUtils.createError(e);
        }
    }

    public static Object readFloat32(ObjectValue dataChannelObj) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            return channel.readDouble(Representation.BIT_32);
        }
        catch (IOException e) {
            log.error("error occurred while reading Float32", (Throwable)e);
            return IOUtils.createError(e);
        }
    }

    public static Object readFloat64(ObjectValue dataChannelObj) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            return channel.readDouble(Representation.BIT_64);
        }
        catch (IOException e) {
            log.error("error occurred while reading Float64", (Throwable)e);
            return IOUtils.createError(e);
        }
    }

    public static Object readBool(ObjectValue dataChannelObj) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            return channel.readBoolean();
        }
        catch (IOException e) {
            log.error("error while reading boolean", (Throwable)e);
            return IOUtils.createError(e);
        }
    }

    public static Object readString(ObjectValue dataChannelObj, long nBytes, String encoding) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        if (channel.hasReachedEnd()) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("Channel %d reached it's end", channel.hashCode()));
            }
            return IOUtils.createEoFError();
        }
        try {
            return channel.readString((int)nBytes, encoding);
        }
        catch (IOException e) {
            String msg = "Error occurred while reading string: " + e.getMessage();
            log.error(msg, (Throwable)e);
            return IOUtils.createError(msg);
        }
    }

    public static Object readVarInt(ObjectValue dataChannelObj) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            return channel.readLong(Representation.VARIABLE).getValue();
        }
        catch (IOException e) {
            log.error("Error occurred while reading VarInt", (Throwable)e);
            return IOUtils.createError(e);
        }
    }

    public static Object closeDataChannel(ObjectValue dataChannel) {
        DataChannel channel = (DataChannel)dataChannel.getNativeData("data_channel");
        try {
            channel.close();
        }
        catch (ClosedChannelException e) {
            return IOUtils.createError("channel already closed.");
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static void initWritableDataChannel(ObjectValue dataChannelObj, ObjectValue byteChannelObj, Object order) {
        try {
            ByteOrder byteOrder = DataChannelUtils.getByteOrder((String)order);
            Channel channel = (Channel)byteChannelObj.getNativeData("byteChannel");
            DataChannel dataChannel = new DataChannel(channel, byteOrder);
            dataChannelObj.addNativeData("data_channel", (Object)dataChannel);
        }
        catch (Exception e) {
            String message = "error while creating data channel: " + e.getMessage();
            log.error(message, (Throwable)e);
            throw IOUtils.createError(message);
        }
    }

    public static Object writeInt16(ObjectValue dataChannelObj, long value) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeLong(value, Representation.BIT_16);
        }
        catch (IOException e) {
            log.error("Error occurred while writing int16.", (Throwable)e);
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeInt32(ObjectValue dataChannelObj, long value) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeLong(value, Representation.BIT_32);
        }
        catch (IOException e) {
            log.error("Error occurred while writing int32.", (Throwable)e);
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeInt64(ObjectValue dataChannelObj, long value) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeLong(value, Representation.BIT_64);
        }
        catch (IOException e) {
            log.error("Error occurred while writing int64.", (Throwable)e);
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeFloat32(ObjectValue dataChannelObj, double value) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeDouble(value, Representation.BIT_32);
        }
        catch (IOException e) {
            log.error("Error occurred while writing float32.", (Throwable)e);
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeFloat64(ObjectValue dataChannelObj, double value) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeDouble(value, Representation.BIT_64);
        }
        catch (IOException e) {
            log.error("Error occurred while writing float64.", (Throwable)e);
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeBool(ObjectValue dataChannelObj, boolean value) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeBoolean(value);
        }
        catch (IOException e) {
            log.error("Error occurred while writing boolean.", (Throwable)e);
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeString(ObjectValue dataChannelObj, String value, String encoding) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeString(value, encoding);
        }
        catch (IOException e) {
            log.error("Error occurred while writing string.", (Throwable)e);
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeVarInt(ObjectValue dataChannelObj, long value) {
        DataChannel channel = (DataChannel)dataChannelObj.getNativeData("data_channel");
        try {
            channel.writeLong(value, Representation.VARIABLE);
        }
        catch (IOException e) {
            log.error("Error occurred while writing VarInt.", (Throwable)e);
            return IOUtils.createError(e);
        }
        return null;
    }
}

