/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Locale;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.stdlib.io.channels.FileIOChannel;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.channels.base.DelimitedRecordChannel;
import org.ballerinalang.stdlib.io.csv.Format;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.ballerinalang.stdlib.io.utils.IOConstants;

public class IOUtils {
    private IOUtils() {
    }

    public static ErrorValue createError(String errorMsg) {
        return BallerinaErrors.createError((String)IOConstants.ErrorCode.GenericError.errorCode(), IOUtils.createDetailRecord(errorMsg, null));
    }

    public static ErrorValue createError(Throwable error) {
        return IOUtils.createError(error.getMessage());
    }

    public static ErrorValue createError(IOConstants.ErrorCode code, String errorMsg) {
        return BallerinaErrors.createError((String)code.errorCode(), IOUtils.createDetailRecord(errorMsg, null));
    }

    public static ErrorValue createEoFError() {
        return IOUtils.createError(IOConstants.ErrorCode.EoF, "EoF when reading from the channel");
    }

    private static MapValue<String, Object> createDetailRecord(Object ... values) {
        MapValue detail = BallerinaValues.createRecordValue((BPackage)IOConstants.IO_PACKAGE_ID, (String)"Detail");
        return BallerinaValues.createRecord((MapValue)detail, (Object[])values);
    }

    public static int writeFull(Channel channel, byte[] content, int offset) throws IOException {
        while ((offset += IOUtils.write(channel, content, offset)) < content.length) {
        }
        return offset;
    }

    private static int write(Channel channel, byte[] content, int offset) throws IOException {
        ByteBuffer writeBuffer = ByteBuffer.wrap(content);
        writeBuffer.position(offset);
        int write = channel.write(writeBuffer);
        return offset += write;
    }

    public static void writeFull(CharacterChannel characterChannel, String payload) throws BallerinaIOException {
        try {
            int numberOfCharsWritten;
            int totalNumberOfCharsWritten = 0;
            int lengthOfPayload = payload.getBytes().length;
            while ((totalNumberOfCharsWritten += (numberOfCharsWritten = characterChannel.write(payload, 0))) != lengthOfPayload && numberOfCharsWritten != 0) {
            }
            if (totalNumberOfCharsWritten != lengthOfPayload) {
                String message = String.format("JSON payload was partially written expected: %d, written : %d", lengthOfPayload, totalNumberOfCharsWritten);
                throw new BallerinaIOException(message);
            }
        }
        catch (IOException e) {
            throw new BallerinaIOException("unable to write the content fully", e);
        }
    }

    public static int readFull(Channel channel, byte[] content) throws IOException, ErrorValue {
        int numberOfBytesToRead = content.length;
        int nBytesRead = 0;
        while ((nBytesRead += IOUtils.read(channel, content)) < numberOfBytesToRead && !channel.hasReachedEnd()) {
        }
        return nBytesRead;
    }

    private static int read(Channel channel, byte[] content) throws IOException, ErrorValue {
        if (channel.hasReachedEnd()) {
            throw IOUtils.createEoFError();
        }
        return channel.read(ByteBuffer.wrap(content));
    }

    private static void createDirsExtended(Path path) throws IOException {
        Path parent = path.getParent();
        if (parent != null && !parent.toFile().exists()) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }

    public static FileChannel openFileChannelExtended(Path path, String accessMode) throws BallerinaIOException {
        String accessLC = accessMode.toLowerCase(Locale.getDefault());
        HashSet<StandardOpenOption> opts = new HashSet<StandardOpenOption>();
        if (accessLC.contains("r")) {
            if (!path.toFile().exists()) {
                String msg = "no such file or directory: " + path.toFile().getAbsolutePath();
                throw IOUtils.createError(IOConstants.ErrorCode.FileNotFoundError, msg);
            }
            if (!Files.isReadable(path)) {
                throw new BallerinaIOException("file is not readable: " + path);
            }
            opts.add(StandardOpenOption.READ);
        }
        boolean write = accessLC.contains("w");
        boolean append = accessLC.contains("a");
        try {
            if (write || append) {
                if (path.toFile().exists() && !Files.isWritable(path)) {
                    throw new BallerinaIOException("file is not writable: " + path);
                }
                IOUtils.createDirsExtended(path);
                opts.add(StandardOpenOption.CREATE);
                if (append) {
                    opts.add(StandardOpenOption.APPEND);
                } else {
                    opts.add(StandardOpenOption.WRITE);
                }
            }
            return FileChannel.open(path, opts, new FileAttribute[0]);
        }
        catch (AccessDeniedException e) {
            String msg = "do not have necessary permissions to access: " + e.getMessage();
            throw IOUtils.createError(IOConstants.ErrorCode.AccessDeniedError, msg);
        }
        catch (IOException | UnsupportedOperationException e) {
            throw new BallerinaIOException("fail to open file: " + e.getMessage(), e);
        }
    }

    public static DelimitedRecordChannel createDelimitedRecordChannelExtended(String filePath, String encoding, String mode, Format format) throws BallerinaIOException {
        Path path = Paths.get(filePath, new String[0]);
        FileChannel sourceChannel = IOUtils.openFileChannelExtended(path, mode);
        FileIOChannel fileIOChannel = new FileIOChannel(sourceChannel);
        CharacterChannel characterChannel = new CharacterChannel(fileIOChannel, Charset.forName(encoding).name());
        return new DelimitedRecordChannel(characterChannel, format);
    }
}

