/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.ballerinalang.jvm.util.exceptions.BallerinaException;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.stdlib.io.channels.AbstractNativeChannel;
import org.ballerinalang.stdlib.io.channels.BlobChannel;
import org.ballerinalang.stdlib.io.channels.BlobIOChannel;
import org.ballerinalang.stdlib.io.channels.FileIOChannel;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.ballerinalang.stdlib.io.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteChannelUtils
extends AbstractNativeChannel {
    private static final Logger log = LoggerFactory.getLogger(ByteChannelUtils.class);
    private static final String READ_ACCESS_MODE = "r";
    private static final String WRITE_ACCESS_MODE = "w";
    private static final String APPEND_ACCESS_MODE = "a";

    private ByteChannelUtils() {
    }

    public static Object read(ObjectValue channel, long nBytes) {
        int arraySize = nBytes <= 0L ? 16384 : (int)nBytes;
        Channel byteChannel = (Channel)channel.getNativeData("byteChannel");
        ByteBuffer content = ByteBuffer.wrap(new byte[arraySize]);
        if (byteChannel.hasReachedEnd()) {
            return IOUtils.createEoFError();
        }
        try {
            byteChannel.read(content);
            return BValueCreator.createArrayValue((byte[])ByteChannelUtils.getContentData(content));
        }
        catch (Exception e) {
            String msg = "error occurred while reading bytes from the channel. " + e.getMessage();
            log.error(msg, (Throwable)e);
            return IOUtils.createError(msg);
        }
    }

    private static byte[] getContentData(ByteBuffer contentBuffer) {
        int bufferSize = contentBuffer.limit();
        int readPosition = contentBuffer.position();
        byte[] content = contentBuffer.array();
        boolean startPosition = false;
        if (readPosition == bufferSize) {
            return content;
        }
        return Arrays.copyOfRange(content, 0, readPosition);
    }

    public static Object base64Encode(ObjectValue channel) {
        return Utils.encodeByteChannel(channel, false);
    }

    public static Object base64Decode(ObjectValue channel) {
        return Utils.decodeByteChannel(channel, false);
    }

    public static Object closeByteChannel(ObjectValue channel) {
        Channel byteChannel = (Channel)channel.getNativeData("byteChannel");
        try {
            byteChannel.close();
        }
        catch (ClosedChannelException e) {
            return IOUtils.createError("channel already closed.");
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object write(ObjectValue channel, ArrayValue content, long offset) {
        Channel byteChannel = (Channel)channel.getNativeData("byteChannel");
        ByteBuffer writeBuffer = ByteBuffer.wrap(content.getBytes());
        writeBuffer.position((int)offset);
        try {
            return byteChannel.write(writeBuffer);
        }
        catch (IOException e) {
            log.error("Error occurred while writing to the channel.", (Throwable)e);
            return IOUtils.createError(e);
        }
    }

    public static Object openReadableFile(String pathUrl) {
        Object channel;
        try {
            channel = ByteChannelUtils.createChannel(ByteChannelUtils.inFlow(pathUrl));
        }
        catch (BallerinaIOException e) {
            channel = IOUtils.createError(e);
        }
        catch (ErrorValue e) {
            return e;
        }
        return channel;
    }

    public static Object openWritableFile(String pathUrl, boolean accessMode) {
        try {
            return ByteChannelUtils.createChannel(ByteChannelUtils.inFlow(pathUrl, accessMode));
        }
        catch (BallerinaException | BallerinaIOException e) {
            return IOUtils.createError(e);
        }
        catch (ErrorValue e) {
            return e;
        }
    }

    public static Object createReadableChannel(ArrayValue content) {
        try {
            Channel channel = ByteChannelUtils.inFlow(content);
            return ByteChannelUtils.createChannel(channel);
        }
        catch (Exception e) {
            return IOUtils.createError(e);
        }
    }

    private static Channel inFlow(String pathUrl) throws BallerinaIOException {
        Path path = Paths.get(pathUrl, new String[0]);
        FileChannel fileChannel = IOUtils.openFileChannelExtended(path, READ_ACCESS_MODE);
        FileIOChannel channel = new FileIOChannel(fileChannel);
        channel.setReadable(true);
        return channel;
    }

    private static Channel inFlow(String pathUrl, boolean accessMode) throws BallerinaIOException {
        Path path = Paths.get(pathUrl, new String[0]);
        FileChannel fileChannel = accessMode ? IOUtils.openFileChannelExtended(path, APPEND_ACCESS_MODE) : IOUtils.openFileChannelExtended(path, WRITE_ACCESS_MODE);
        return new FileIOChannel(fileChannel);
    }

    private static Channel inFlow(ArrayValue contentArr) {
        byte[] content = ByteChannelUtils.shrink(contentArr);
        ByteArrayInputStream contentStream = new ByteArrayInputStream(content);
        ReadableByteChannel readableByteChannel = Channels.newChannel(contentStream);
        return new BlobIOChannel(new BlobChannel(readableByteChannel));
    }

    private static byte[] shrink(ArrayValue array) {
        int contentLength = array.size();
        byte[] content = new byte[contentLength];
        System.arraycopy(array.getBytes(), 0, content, 0, contentLength);
        return content;
    }
}

