/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.HandleValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BValueCreator;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.channels.base.DelimitedRecordChannel;
import org.ballerinalang.stdlib.io.csv.Format;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordChannelUtils {
    private static final Logger log = LoggerFactory.getLogger(RecordChannelUtils.class);
    private static final String DEFAULT = "default";

    private RecordChannelUtils() {
    }

    public static void initRecordChannel(ObjectValue textRecordChannel, ObjectValue characterChannelInfo, String fieldSeparator, String recordSeparator, String format) {
        try {
            CharacterChannel characterChannel = (CharacterChannel)characterChannelInfo.getNativeData("char_channel");
            DelimitedRecordChannel delimitedRecordChannel = DEFAULT.equals(format) ? new DelimitedRecordChannel(characterChannel, recordSeparator, fieldSeparator) : new DelimitedRecordChannel(characterChannel, Format.valueOf(format));
            textRecordChannel.addNativeData("txt_record", (Object)delimitedRecordChannel);
        }
        catch (Exception e) {
            String message = "error occurred while converting character channel to textRecord channel: " + e.getMessage();
            log.error(message, (Throwable)e);
            throw IOUtils.createError(message);
        }
    }

    public static boolean hasNext(ObjectValue channel) {
        Object textChannel = channel.getNativeData("txt_record");
        if (textChannel == null) {
            return false;
        }
        DelimitedRecordChannel textRecordChannel = (DelimitedRecordChannel)textChannel;
        if (!textRecordChannel.hasReachedEnd()) {
            try {
                return textRecordChannel.hasNext();
            }
            catch (BallerinaIOException e) {
                String msg = "error occurred while checking hasNext on ReadableTextRecordChannel: " + e.getMessage();
                log.error(msg, (Throwable)e);
                throw IOUtils.createError(msg);
            }
        }
        return false;
    }

    public static Object getNext(ObjectValue channel) {
        DelimitedRecordChannel textRecordChannel = (DelimitedRecordChannel)channel.getNativeData("txt_record");
        if (textRecordChannel.hasReachedEnd()) {
            return IOUtils.createEoFError();
        }
        try {
            String[] records = textRecordChannel.read();
            Object[] handleValues = new HandleValue[records.length];
            for (int i = 0; i < records.length; ++i) {
                handleValues[i] = new HandleValue((Object)records[i]);
            }
            return BValueCreator.createArrayValue((Object[])handleValues, (BArrayType)new BArrayType(BTypes.typeHandle));
        }
        catch (BallerinaIOException e) {
            log.error("error occurred while reading next text record from ReadableTextRecordChannel", (Throwable)e);
            return IOUtils.createError(e);
        }
    }

    public static Object write(ObjectValue channel, ArrayValue content) {
        DelimitedRecordChannel delimitedRecordChannel = (DelimitedRecordChannel)channel.getNativeData("txt_record");
        try {
            String[] arr = new String[content.size()];
            for (int i = 0; i < content.size(); ++i) {
                String st;
                HandleValue handleValue = (HandleValue)content.get((long)i);
                arr[i] = st = (String)handleValue.getValue();
            }
            delimitedRecordChannel.write(arr);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object close(ObjectValue channel) {
        DelimitedRecordChannel recordChannel = (DelimitedRecordChannel)channel.getNativeData("txt_record");
        try {
            recordChannel.close();
        }
        catch (ClosedChannelException e) {
            return IOUtils.createError("channel already closed.");
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }
}

