/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.channels.base;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Buffer {
    private ByteBuffer byteBuffer;
    private int minimumSizeOfBuffer;
    private static final Logger log = LoggerFactory.getLogger(Buffer.class);

    public Buffer(int minimumSizeOfBuffer) {
        this.minimumSizeOfBuffer = minimumSizeOfBuffer;
    }

    private ByteBuffer remainingContent(int totalNumberOfBytesRequired) {
        ByteBuffer remainingContent = null;
        if (null != this.byteBuffer) {
            remainingContent = this.byteBuffer.slice();
        } else if (log.isDebugEnabled()) {
            log.debug("ByteBuffer has not being initialized, buffer will be initialized while reading the requested amount of " + totalNumberOfBytesRequired + " of bytes");
        }
        return remainingContent;
    }

    private ByteBuffer allocate(int size) {
        if (size < this.minimumSizeOfBuffer) {
            size = this.minimumSizeOfBuffer;
        }
        return ByteBuffer.allocate(size);
    }

    private ByteBuffer resize(ByteBuffer srcBuffer, int requiredNumberOfBytes) {
        srcBuffer.flip();
        int totalBytesRead = srcBuffer.limit();
        if (totalBytesRead > requiredNumberOfBytes) {
            srcBuffer.limit(requiredNumberOfBytes);
        }
        ByteBuffer resizedBuffer = srcBuffer.slice();
        srcBuffer.limit(totalBytesRead);
        srcBuffer.position(resizedBuffer.capacity());
        return resizedBuffer;
    }

    public void reverse(int count) throws BallerinaIOException {
        int reversedByteBufferPosition;
        if (null != this.byteBuffer) {
            reversedByteBufferPosition = this.byteBuffer.position() - count;
            boolean minimumBytePosition = false;
            if (reversedByteBufferPosition < 0) {
                String message = "The specified byte count " + count + " is not being read, hence cannot be reversed";
                throw new BallerinaIOException(message);
            }
        } else {
            String message = "ByteBuffer not initialized, please initialize it before reversing";
            throw new BallerinaIOException(message);
        }
        this.byteBuffer.position(reversedByteBufferPosition);
    }

    private ByteBuffer deepCopy(ByteBuffer srcBuffer) {
        ByteBuffer dstBuffer = ByteBuffer.allocate(srcBuffer.capacity());
        srcBuffer.rewind();
        dstBuffer.put(srcBuffer);
        srcBuffer.rewind();
        dstBuffer.flip();
        return dstBuffer;
    }

    private ByteBuffer copyRemainingContent(int numberOfBytesRequested, ByteBuffer content) {
        content.limit(numberOfBytesRequested);
        ByteBuffer slicedBuffer = content.slice();
        int capacity = slicedBuffer.capacity();
        int offset = slicedBuffer.arrayOffset();
        this.byteBuffer.position(offset + capacity);
        return this.deepCopy(slicedBuffer);
    }

    public ByteBuffer get(int numberOfBytesRequested, Channel channel) throws IOException {
        ByteBuffer remainingContent = this.remainingContent(numberOfBytesRequested);
        if (null != remainingContent && remainingContent.capacity() >= numberOfBytesRequested) {
            return this.copyRemainingContent(numberOfBytesRequested, remainingContent);
        }
        if (null != remainingContent && remainingContent.hasRemaining()) {
            remainingContent = this.deepCopy(remainingContent);
        }
        if (this.byteBuffer != null && this.byteBuffer.capacity() >= numberOfBytesRequested) {
            this.byteBuffer.clear();
        } else {
            this.byteBuffer = this.allocate(numberOfBytesRequested);
        }
        if (null != remainingContent && remainingContent.hasRemaining()) {
            this.byteBuffer.put(remainingContent);
        }
        channel.read(this.byteBuffer);
        return this.resize(this.byteBuffer, numberOfBytesRequested);
    }
}

